
/*****************************************************************
*
* ruby_hildon_weekday_picker.c 
*
* Author: Clive Andrews, Reality Bites
*
* Date : 04/08/2008
*
* Copyright (c) C.Andrews 2008
*
* Licenced under the GNU licence
*
*
******************************************************************/
 
#include <ruby.h>
#include <hildon/hildon.h>
#include "rbhildon.h"

#define _SELF(self) (HILDON_WEEKDAY_PICKER(RVAL2GOBJ(self)))

static ID id_to_a;

/* Initialisation */


static VALUE
initialize ( self )
    VALUE self;
{
    RBGTK_INITIALIZE(self,hildon_weekday_picker_new () );
    return Qnil;
}


/* methods */


static VALUE
set_day(picker, day)
    VALUE picker, day;
{
       hildon_weekday_picker_set_day (_SELF ( picker ), NUM2UINT( day ) );
    return picker;
}

static VALUE
unset_day(picker, day)
    VALUE picker, day;
{
       hildon_weekday_picker_unset_day (_SELF ( picker ), NUM2UINT( day ) );
    return picker;
}

static VALUE
toggle_day(picker, day)
    VALUE picker, day;
{
       hildon_weekday_picker_toggle_day (_SELF ( picker ), NUM2UINT( day ) );
    return picker;
}

static VALUE
set_all(picker)
    VALUE picker;
{
       hildon_weekday_picker_set_all (_SELF ( picker ) );
    return picker;
}

static VALUE
unset_all(picker)
    VALUE picker;
{
       hildon_weekday_picker_unset_all (_SELF ( picker ) );
    return picker;
}

static VALUE
isset_day(picker, day)
    VALUE picker, day;
{
    gboolean ret =    hildon_weekday_picker_isset_day (_SELF ( picker ), NUM2UINT( day ) );
    return CBOOL2RVAL( ret );
}


/* Class Initialisation */


void 
Init_hildon_weekday_picker()
{
   
    VALUE win = G_DEF_CLASS(HILDON_TYPE_WEEKDAY_PICKER, "WeekdayPicker", mHildon);

    id_to_a = rb_intern("to_a"); 
    
    rb_define_method(win, "initialize", initialize, 0);

     rb_define_method(win, "set_day", set_day, 1);

     rb_define_method(win, "unset_day", unset_day, 1);

     rb_define_method(win, "toggle_day", toggle_day, 1);

     rb_define_method(win, "set_all", set_all, 0);

     rb_define_method(win, "unset_all", unset_all, 0);

     rb_define_method(win, "isset_day", isset_day, 1);
}


