
/*****************************************************************
*
* ruby_hildon_volumebar_range.c 
*
* Author: Clive Andrews, Reality Bites
*
* Date : 04/08/2008
*
* Copyright (c) C.Andrews 2008
*
* Licenced under the GNU licence
*
*
******************************************************************/
 
#include <ruby.h>
#include <hildon/hildon.h>
#include "rbhildon.h"

#define _SELF(self) (HILDON_VOLUMEBAR_RANGE(RVAL2GOBJ(self)))

static ID id_to_a;

/* Initialisation */


static VALUE
initialize ( self , orientation)
    VALUE self, orientation;
{
   RBGTK_INITIALIZE(self,hildon_volumebar_range_new (NUM2INT ( orientation ) ) );   
    return Qnil;
}


/* methods */




static VALUE
get_level(self)
    VALUE self;
{
    gdouble ret =    hildon_volumebar_range_get_level (_SELF ( self ) );
    return INT2NUM( ret );
}

static VALUE
set_level(self, level)
    VALUE self, level;
{
       hildon_volumebar_range_set_level (_SELF ( self ), NUM2INT( level ) );
    return self;
}


/* Class Initialisation */


void 
Init_hildon_volumebar_range()
{
   
    VALUE win = G_DEF_CLASS(HILDON_TYPE_VOLUMEBAR_RANGE, "VolumebarRange", mHildon);

    id_to_a = rb_intern("to_a"); 
    
    rb_define_method(win, "initialize", initialize, 1);

  /*   rb_define_method(win, "new", new, 0); */

     rb_define_method(win, "get_level", get_level, 0);

     rb_define_method(win, "set_level", set_level, 1);
}


