
/*****************************************************************
*
* ruby_hildon_set_password_dialog.c 
*
* Author: Clive Andrews, Reality Bites
*
* Date : 04/08/2008
*
* Copyright (c) C.Andrews 2008
*
* Licenced under the GNU licence
*
*
******************************************************************/
 
#include <ruby.h>
#include <hildon/hildon.h>
#include "rbhildon.h"

#define _SELF(self) (HILDON_SET_PASSWORD_DIALOG(RVAL2GOBJ(self)))

static ID id_to_a;

/* Initialisation */


static VALUE
initialize ( self , parent, modify_protection,password )
    VALUE self , parent, modify_protection,password ;
{
    if ( password == Qnil )
    {
	RBGTK_INITIALIZE(self,hildon_set_password_dialog_new (GTK_WINDOW ( RVAL2GOBJ (parent) ), RVAL2CBOOL ( modify_protection ) ) );   
    }
    else
    {
	 RBGTK_INITIALIZE(self,hildon_set_password_dialog_new_with_default (GTK_WINDOW ( RVAL2GOBJ (parent) ), RVAL2CSTR( password ), RVAL2CBOOL ( modify_protection ) ) );    
    }
    return Qnil;
}


/* methods */

/*
static VALUE
new_with_default(parent, password, modify_protection)
    VALUE parent, password, modify_protection;
{
    GtkWidget* ret =    hildon_set_password_dialog_new_with_default (_SELF ( parent ), RVAL2CSTR( password ), RVAL2CBOOL ( modify_protection ) );
    return GOBJ2RVAL ( ret ) ;
}
*/

static VALUE
get_protected(dialog)
    VALUE dialog;
{
    gboolean ret =    hildon_set_password_dialog_get_protected (_SELF ( dialog ) );
    return CBOOL2RVAL( ret );
}

static VALUE
set_message(dialog, message)
    VALUE dialog, message;
{
       hildon_set_password_dialog_set_message (_SELF ( dialog ), RVAL2CSTR( message ) );
    return dialog;
}


/* Class Initialisation */


void 
Init_hildon_set_password_dialog()
{
   
    VALUE win = G_DEF_CLASS(HILDON_TYPE_SET_PASSWORD_DIALOG, "SetPasswordDialog", mHildon);

    id_to_a = rb_intern("to_a"); 
    
    rb_define_method(win, "initialize", initialize, 3);

   /*  rb_define_method(win, "new_with_default", new_with_default, 2); */

     rb_define_method(win, "get_protected", get_protected, 0);

     rb_define_method(win, "set_message", set_message, 1);
}


