
/*****************************************************************
*
* ruby_hildon_seekbar.c 
*
* Author: Clive Andrews, Reality Bites
*
* Date : 04/08/2008
*
* Copyright (c) C.Andrews 2008
*
* Licenced under the GNU licence
*
*
******************************************************************/
 
#include <ruby.h>
#include <hildon/hildon.h>
#include "rbhildon.h"

#define _SELF(self) (HILDON_SEEKBAR(RVAL2GOBJ(self)))

static ID id_to_a;

/* Initialisation */


static VALUE
initialize ( self )
    VALUE self;
{
    RBGTK_INITIALIZE(self,hildon_seekbar_new () );
    return Qnil;
}


/* methods */


static VALUE
get_total_time(seekbar)
    VALUE seekbar;
{
    gint ret =    hildon_seekbar_get_total_time (_SELF ( seekbar ) );
    return INT2NUM( ret );
}

static VALUE
set_total_time(seekbar, time)
    VALUE seekbar, time;
{
       hildon_seekbar_set_total_time (_SELF ( seekbar ), NUM2INT( time ) );
    return seekbar;
}

static VALUE
get_position(seekbar)
    VALUE seekbar;
{
    gint ret =    hildon_seekbar_get_position (_SELF ( seekbar ) );
    return INT2NUM( ret );
}

static VALUE
set_position(seekbar, time)
    VALUE seekbar, time;
{
       hildon_seekbar_set_position (_SELF ( seekbar ), NUM2INT( time ) );
    return seekbar;
}

static VALUE
set_fraction(seekbar, fraction)
    VALUE seekbar, fraction;
{
       hildon_seekbar_set_fraction (_SELF ( seekbar ), NUM2UINT( fraction ) );
    return seekbar;
}

static VALUE
get_fraction(seekbar)
    VALUE seekbar;
{
    guint ret =    hildon_seekbar_get_fraction (_SELF ( seekbar ) );
    return UINT2NUM( ret );
}


/* Class Initialisation */


void 
Init_hildon_seekbar()
{
   
    VALUE win = G_DEF_CLASS(HILDON_TYPE_SEEKBAR, "Seekbar", mHildon);

    id_to_a = rb_intern("to_a"); 
    
    rb_define_method(win, "initialize", initialize, 0);

     rb_define_method(win, "get_total_time", get_total_time, 0);

     rb_define_method(win, "set_total_time", set_total_time, 1);

     rb_define_method(win, "get_position", get_position, 0);

     rb_define_method(win, "set_position", set_position, 1);

     rb_define_method(win, "set_fraction", set_fraction, 1);

     rb_define_method(win, "get_fraction", get_fraction, 0);
}


