
/*****************************************************************
*
* ruby_hildon_range_editor.c 
*
* Author: Clive Andrews, Reality Bites
*
* Date : 04/08/2008
*
* Copyright (c) C.Andrews 2008
*
* Licenced under the GNU licence
*
*
******************************************************************/
 
#include <ruby.h>
#include <hildon/hildon.h>
#include "rbhildon.h"

#define _SELF(self) (HILDON_RANGE_EDITOR(RVAL2GOBJ(self)))

static ID id_to_a;

/* Initialisation */


static VALUE
initialize ( self )
    VALUE self;
{
    RBGTK_INITIALIZE(self,hildon_range_editor_new () );
    return Qnil;
}


/* methods */

/*
static VALUE
new_with_separator(separator)
    VALUE separator;
{
    GtkWidget* ret =    hildon_range_editor_new_with_separator (_SELF ( separator ) );
    return GOBJ2RVAL ( ret ) ;
}
*/


static VALUE
set_range(editor,start,end)
    VALUE editor, start,end;
{
  /*
	int start =  NUM2INT ( range_first(range) );
        int end =  NUM2INT ( range_last(range) );
	*/
	hildon_range_editor_set_range (_SELF ( editor ),  NUM2INT(start),  NUM2INT(end)  );
    return editor;
}

static VALUE
get_range(editor)
    VALUE editor;
{
	int start, end;
       hildon_range_editor_get_range (_SELF ( editor ), &start, &end );
    return rb_range_new( INT2NUM( start ) , INT2NUM( end), 0 );
}

static VALUE
set_limits(editor, start, end)
    VALUE editor, start, end;
{
       hildon_range_editor_set_limits (_SELF ( editor ), NUM2INT( start ), NUM2INT( end ) );
    return editor;
}

static VALUE
set_lower(editor, value)
    VALUE editor, value;
{
       hildon_range_editor_set_lower (_SELF ( editor ), NUM2INT( value ) );
    return editor;
}

static VALUE
set_higher(editor, value)
    VALUE editor, value;
{
       hildon_range_editor_set_higher (_SELF ( editor ), NUM2INT( value ) );
    return editor;
}

static VALUE
get_lower(editor)
    VALUE editor;
{
    gint ret =    hildon_range_editor_get_lower (_SELF ( editor ) );
    return INT2NUM( ret );
}

static VALUE
get_higher(editor)
    VALUE editor;
{
    gint ret =    hildon_range_editor_get_higher (_SELF ( editor ) );
    return INT2NUM( ret );
}

static VALUE
set_min(editor, value)
    VALUE editor, value;
{
       hildon_range_editor_set_min (_SELF ( editor ), NUM2INT( value ) );
    return editor;
}

static VALUE
set_max(editor, value)
    VALUE editor, value;
{
       hildon_range_editor_set_max (_SELF ( editor ), NUM2INT( value ) );
    return editor;
}

static VALUE
get_min(editor)
    VALUE editor;
{
    gint ret =    hildon_range_editor_get_min (_SELF ( editor ) );
    return INT2NUM( ret );
}

static VALUE
get_max(editor)
    VALUE editor;
{
    gint ret =    hildon_range_editor_get_max (_SELF ( editor ) );
    return INT2NUM( ret );
}

static VALUE
set_separator(editor, separator)
    VALUE editor, separator;
{
       hildon_range_editor_set_separator (_SELF ( editor ), RVAL2CSTR( separator ) );
    return editor;
}


/* Class Initialisation */


void 
Init_hildon_range_editor()
{
   
    VALUE win = G_DEF_CLASS(HILDON_TYPE_RANGE_EDITOR, "RangeEditor", mHildon);

    id_to_a = rb_intern("to_a"); 
    
    rb_define_method(win, "initialize", initialize, 0);

  /*   rb_define_method(win, "new_with_separator", new_with_separator, 0); */

     rb_define_method(win, "set_range", set_range, 2);

     rb_define_method(win, "get_range", get_range, 0);

     rb_define_method(win, "set_limits", set_limits, 2);

     rb_define_method(win, "set_lower", set_lower, 1);

     rb_define_method(win, "set_higher", set_higher, 1);

     rb_define_method(win, "get_lower", get_lower, 0);

     rb_define_method(win, "get_higher", get_higher, 0);

     rb_define_method(win, "set_min", set_min, 1);

     rb_define_method(win, "set_max", set_max, 1);

     rb_define_method(win, "get_min", get_min, 0);

     rb_define_method(win, "get_max", get_max, 0);

     rb_define_method(win, "set_separator", set_separator, 1);
}


