
/*****************************************************************
*
* ruby_hildon_program.c 
*
* Author: Clive Andrews, Reality Bites
*
* Date : 04/08/2008
*
* Copyright (c) C.Andrews 2008
*
* Licenced under the GNU licence
*
*
******************************************************************/
 
#include <ruby.h>
#include <hildon/hildon.h>
#include "rbhildon.h"

#define _SELF(self) (HILDON_PROGRAM(RVAL2GOBJ(self)))

static ID id_to_a;

/* Initialisation */


static VALUE
initialize ( self )
    VALUE self;
{
    G_INITIALIZE(self, hildon_program_get_instance ()   );
    return Qnil;
}


/* methods */


static VALUE
add_window(self, window)
    VALUE self, window;
{
       hildon_program_add_window (_SELF ( self ), HILDON_WINDOW ( RVAL2GOBJ ( window ) ) );
    return self;
}

static VALUE
remove_window(self, window)
    VALUE self, window;
{
       hildon_program_remove_window (_SELF ( self ), HILDON_WINDOW ( RVAL2GOBJ ( window ) ) );
    return self;
}

static VALUE
set_can_hibernate(self, can_hibernate)
    VALUE self, can_hibernate;
{
       hildon_program_set_can_hibernate (_SELF ( self ), RVAL2CBOOL ( can_hibernate ) );
    return self;
}

static VALUE
get_can_hibernate(self)
    VALUE self;
{
    gboolean ret =    hildon_program_get_can_hibernate (_SELF ( self ) );
    return CBOOL2RVAL( ret );
}

static VALUE
set_common_menu(self, menu)
    VALUE self, menu;
{
       hildon_program_set_common_menu (_SELF ( self ), GTK_MENU ( RVAL2GOBJ ( menu ) ) );
    return self;
}

static VALUE
get_common_menu(self)
    VALUE self;
{
    GtkMenu* ret =    hildon_program_get_common_menu (_SELF ( self ) );
    return GOBJ2RVAL ( ret ) ;
}

static VALUE
set_common_toolbar(self, toolbar)
    VALUE self, toolbar;
{
       hildon_program_set_common_toolbar (_SELF ( self ), GTK_TOOLBAR ( RVAL2GOBJ ( toolbar ) ) );
    return self;
}

static VALUE
get_common_toolbar(self)
    VALUE self;
{
    GtkToolbar* ret =    hildon_program_get_common_toolbar (_SELF ( self ) );
    return GOBJ2RVAL ( ret ) ;
}

static VALUE
get_is_topmost(self)
    VALUE self;
{
    gboolean ret =    hildon_program_get_is_topmost (_SELF ( self ) );
    return CBOOL2RVAL( ret );
}


/* Class Initialisation */


void 
Init_hildon_program()
{
   
    VALUE win = G_DEF_CLASS(HILDON_TYPE_PROGRAM, "Program", mHildon);

    id_to_a = rb_intern("to_a"); 
    
    rb_define_method(win, "initialize", initialize, 0);

     rb_define_method(win, "add_window", add_window, 1);

     rb_define_method(win, "remove_window", remove_window, 1);

     rb_define_method(win, "set_can_hibernate", set_can_hibernate, 1);

     rb_define_method(win, "get_can_hibernate", get_can_hibernate, 0);

     rb_define_method(win, "set_common_menu", set_common_menu, 1);

     rb_define_method(win, "get_common_menu", get_common_menu, 0);

     rb_define_method(win, "set_common_toolbar", set_common_toolbar, 1);

     rb_define_method(win, "get_common_toolbar", get_common_toolbar, 0);

     rb_define_method(win, "get_is_topmost", get_is_topmost, 0);
}


