
/*****************************************************************
*
* ruby_hildon_color_button.c 
*
* Author: Clive Andrews, Reality Bites
*
* Date : 04/08/2008
*
* Copyright (c) C.Andrews 2008
*
* Licenced under the GNU licence
*
*
******************************************************************/
 
#include <ruby.h>
#include <hildon/hildon.h>
#include "rbhildon.h"

#define _SELF(self) (HILDON_COLOR_BUTTON(RVAL2GOBJ(self)))

static ID id_to_a;

/* Initialisation */


static VALUE
initialize ( self )
    VALUE self;
{
    RBGTK_INITIALIZE(self,hildon_color_button_new () );
    return Qnil;
}


/* methods */


static VALUE
new_with_color(color)
    VALUE color;
{
    GtkWidget* ret =    hildon_color_button_new_with_color (_SELF ( color ) );
    return GOBJ2RVAL ( ret ) ;
}

static VALUE
get_color(button)
    VALUE button;
{
       GdkColor* color;
       hildon_color_button_get_color (_SELF ( button ),  color );
    return GDKCOLOR2RVAL(color);
}

static VALUE
set_color(button, color)
    VALUE button, color;
{
       hildon_color_button_set_color (_SELF ( button ), RVAL2GDKCOLOR(color) );
    return button;
}

static VALUE
get_popup_shown(button)
    VALUE button;
{
    gboolean ret =    hildon_color_button_get_popup_shown (_SELF ( button ) );
    return CBOOL2RVAL( ret );
}

static VALUE
popdown(button)
    VALUE button;
{
       hildon_color_button_popdown (_SELF ( button ) );
    return button;
}


/* Class Initialisation */


void 
Init_hildon_color_button()
{
   
    VALUE win = G_DEF_CLASS(HILDON_TYPE_COLOR_BUTTON, "ColorButton", mHildon);

    id_to_a = rb_intern("to_a"); 
    
    rb_define_method(win, "initialize", initialize, 0);

 /*    rb_define_method(win, "new_with_color", new_with_color, 0); */

     rb_define_method(win, "get_color", get_color, 0);

     rb_define_method(win, "set_color", set_color, 1);

     rb_define_method(win, "get_popup_shown", get_popup_shown, 0);

     rb_define_method(win, "popdown", popdown, 0);
}


