// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _LIBGDAMM_PARAMETERLIST_H
#define _LIBGDAMM_PARAMETERLIST_H


#include <glibmm.h>

/* $Id: parameterlist.hg,v 1.11 2006/11/30 06:58:55 murrayc Exp $ */
// -*- C++ -*- //

/* parameterlist.h
 *
 * Copyright 2003 libgdamm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/object.h>
#include <libgdamm/parameter.h>
#include <libgdamm/object.h>
#include <libgdamm/dict.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GdaParameterList GdaParameterList;
typedef struct _GdaParameterListClass GdaParameterListClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{ class ParameterList_Class; } // namespace Gda

} // namespace Gnome
namespace Gnome
{

namespace Gda
{

/** Exception class for Gda parameter list errors.
 */
class ParameterListError : public Glib::Error
{
public:
  enum Code
  {
    PARAMETER_LIST_NO_NODE_ERROR,
    PARAMETER_LIST_NODE_OUTDATED_ERROR,
    PARAMETER_LIST_VALUE_PROV_OBJ_TYPE_ERROR,
    PARAMETER_LIST_VALUE_PROV_DATA_TYPE_ERROR,
    PARAMETER_LIST_VALUE_PROV_INVISIBLE_ERROR,
    PARAMETER_LIST_VALUE_PROV_QUERY_TYPE_ERROR,
    PARAMETER_LIST_DEPENDENCY_NOT_IN_PARAMLIST_ERROR,
    PARAMETER_LIST_DEPENDENCY_POSITION_ERROR,
    PARAMETER_LIST_XML_SPEC_ERROR
  };

  ParameterListError(Code error_code, const Glib::ustring& error_message);
  explicit ParameterListError(GError* gobject);
  Code code() const;

#ifndef DOXYGEN_SHOULD_SKIP_THIS
private:

#ifdef GLIBMM_EXCEPTIONS_ENABLED
  static void throw_func(GError* gobject);
#else
  //When not using exceptions, we just pass the Exception object around without throwing it:
  static std::auto_ptr<Glib::Error> throw_func(GError* gobject);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  friend void wrap_init(); // uses throw_func()
#endif
};

} // namespace Gda

} // namespace Gnome

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gnome::Gda::ParameterListError::Code> : public Glib::Value_Enum<Gnome::Gda::ParameterListError::Code>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{


/** Manages a list of GdaParameter objects which contain individual values.
 *
 * A ParameterList is a list of Parameter objects, but also creates other lists such as:
 * - a list of ParameterListNode structures (the nodes_list attribute): for each parameter a structure is created to show in a single place all the information about each parameter: the DataModel which may restrict the list of values along with the column number in it, and any hint for the parameter (a value made of ParameterListParamHint flags)
 * - a list of ParameterListSource structures (the sources_list attribute): each ParameterListSource structure is complementary to the ParameterListNode structures listed in its "nodes" attribute: there is one such structure for each DataModel which may restrict values of one or more parameters.
 * - a list of ParameterListGroup structures (the groups_list attribute): there is one such structure for each _independant_ parameter (parameters which are constrained by the same data model all appear in the same ParameterListGroup structure).
 *
 * Some queries require arguments before they can be executed. For such queries, the arguments are passed using Parameter objects (the list of parameters can be obtained using Query::get_parameters() or Query::get_parameter_list()).
 *
 * @ingroup DataModels
 */

class ParameterList : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef ParameterList CppObjectType;
  typedef ParameterList_Class CppClassType;
  typedef GdaParameterList BaseObjectType;
  typedef GdaParameterListClass BaseClassType;

private:  friend class ParameterList_Class;
  static CppClassType parameterlist_class_;

private:
  // noncopyable
  ParameterList(const ParameterList&);
  ParameterList& operator=(const ParameterList&);

protected:
  explicit ParameterList(const Glib::ConstructParams& construct_params);
  explicit ParameterList(GdaParameterList* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~ParameterList();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GdaParameterList*       gobj()       { return reinterpret_cast<GdaParameterList*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GdaParameterList* gobj() const { return reinterpret_cast<GdaParameterList*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GdaParameterList* gobj_copy();

private:

protected:

  ParameterList(const Glib::RefPtr<Dict>& dict, const Glib::SListHandle<Parameter>& params);

public:
  static Glib::RefPtr<ParameterList> create(const Glib::SListHandle<Parameter>& param);
  static Glib::RefPtr<ParameterList> create();

  operator bool() const;

  
  /** Get the number of Gda::Parameter objects in @a paramlist 
   */
  guint get_length();

  //TODO: Add add_parameter(bool), add_parameter(string), add_parameter(int), etc?

  
  /** Adds @a param  to the list of parameters managed within @a paramlist .
   * WARNING: the paramlist may decide not to use the @a param  parameter, but to
   * modify another parameter already present within the paramlist. The publicly available
   * lists from the @a paramlist  object may also be changed in the process.
   * @param param A Gda::Parameter object.
   */
  void add_parameter(const Glib::RefPtr<Parameter>& param);
  
  /** Creates and adds a new Gda::Parameter to @a paramlist . The ID and name of the new parameter
   * are set as @a name . The parameter's value is set from @a str .
   * @param name The name to give to the new parameter.
   * @param type The type of parameter to add.
   * @param str The string representation of the parameter.
   * @return The new Gda::Parameter for information, or <tt>0</tt> if an error occurred.
   */
  Glib::RefPtr<Parameter> add_parameter(const Glib::ustring& name, GType type, const Glib::ustring& str);
  
  /** Creates and adds a new Gda::Parameter to @a paramlist . The ID and name of the new parameter
   * are set as @a name . The parameter's value is a copy of @a value .
   * @param name The name to give to the new parameter.
   * @param value The value to give to the new parameter, must not be <tt>0</tt> or of type null.
   * @return The new Gda::Parameter for information, or <tt>0</tt> if an error occurred.
   */
  Glib::RefPtr<Parameter> add_parameter(const Glib::ustring& name, const Value& value);

  
  /** Add to @a paramlist  all the parameters of @a paramlist_to_merge .
   * @param paramlist_to_merge A Gda::ParameterList object.
   */
  void merge(const Glib::RefPtr<ParameterList>& paramlist_to_merge);
  
  /** Checks that @a paramlist  has a coherent public data structure
   * @return <tt>true</tt> if @a paramlist  is coherent.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool is_coherent() const;
#else
  bool is_coherent(std::auto_ptr<Glib::Error>& error) const;
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
  /** Tells if all the paramlist's parameters have valid data
   * @return <tt>true</tt> if the paramlist is valid.
   */
  bool is_valid() const;

  
  /** Finds a Gda::Parameter using its name
   * @param param_name The name of the requested parameter.
   * @return A Gda::Parameter or <tt>0</tt>.
   */
  Glib::RefPtr<Parameter> find_param(const Glib::ustring& param_name);
  
  /** Finds a Gda::Parameter which is to be used by @a user 
   * @param user A Gda::Object object.
   * @return A Gda::Parameter or <tt>0</tt>.
   */
  Glib::RefPtr<Parameter> find_param_for_user(const Glib::RefPtr<Gda::Object>& user);

  /** @brief Restricts the values of a parameter in the list.
   *
   * @param param_name The name of the parameter
   * @param model A Gda::DataModel
   * @param col The reference column in @a model
   * @return Whether the parameter was found and the restriction was set.
   *
   * Sets a limit on the possible values of the paramater with name @a
   * param_name. This function is actually a shortcut for:
   *
   * <code>
   *   Glib::RefPtr<Parameter> param = list->find_param(param_name);
   *   param->restrict_values(model, col);
   * </code>
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool restrict_param_by_name(const Glib::ustring& param_name, const Glib::RefPtr<DataModel>& model, int col);
#else
  bool restrict_param_by_name(const Glib::ustring& param_name, const Glib::RefPtr<DataModel>& model, int col, std::auto_ptr<Glib::Error>& error);
#endif // GLIBMM_EXCEPTIONS_ENABLED

  //TODO: What on earth are these for? Who should use them, and when?
  //_WRAP_METHOD(GdaParameterListNode* find_node_for_param(const Glib::RefPtr<Parameter>& param), gda_parameter_list_find_node_for_param)
  //_WRAP_METHOD(GdaParameterListSource* find_source(const Glib::RefPtr<DataModel>& model), gda_parameter_list_find_source)
  //_WRAP_METHOD(GdaParameterListSource* find_source_for_param(const Glib::RefPtr<Parameter>& param), gda_parameter_list_find_source_for_param)
  //_WRAP_METHOD(GdaParameterListGroup* find_group_for_param(const Glib::RefPtr<Parameter>& param), gda_parameter_list_find_group_for_param)

  
  /** Stores @a value  in @a paramlist  to make it possible for @a paramlist 's users to find a default value
   * for @a param  when one is required, instead of <tt>0</tt>.
   * 
   *  @a paramlist  only provides a storage functionnality, the way the value obtained with 
   * get_param_default_value() is used is up to @a paramlist 's user.
   * @param param A Gda::Parameter object, managed by @a paramlist .
   * @param value A G::Value, of the same type as @a param , or <tt>0</tt>.
   */
  void set_param_default_value(const Glib::RefPtr<const Parameter>& param, const Value& value);
  
  void set_param_default_alias(const Glib::RefPtr<const Parameter>& param, const Glib::RefPtr<const Parameter>& alias);
  Value get_param_default_value(const Glib::RefPtr<const Parameter>& param) const;
  

  /** Get the specification as an XML string. See the new_from_spec_string()
   * form more information about the XML specification string format.
   * @return A new string.
   */
  Glib::ustring get_spec() const;
  
  /** Get the number of Gda::Parameter objects in @a paramlist 
   */
  guint get_length() const;

  
   /**
   * @par Prototype:
   * <tt>void %public_data_changed()</tt>
   */

  Glib::SignalProxy0< void > signal_public_data_changed();

  
   /**
   * @par Prototype:
   * <tt>void %param_plugin_changed(Glib::RefPtr<Parameter> parameter)</tt>
   */

  Glib::SignalProxy1< void,Glib::RefPtr<Parameter> > signal_param_plugin_changed();

  
   /**
   * @par Prototype:
   * <tt>void %param_changed(Glib::RefPtr<Parameter> parameter)</tt>
   */

  Glib::SignalProxy1< void,Glib::RefPtr<Parameter> > signal_param_changed();

  
   /**
   * @par Prototype:
   * <tt>void %param_attr_changed(Glib::RefPtr<Parameter> parameter)</tt>
   */

  Glib::SignalProxy1< void,Glib::RefPtr<Parameter> > signal_param_attr_changed();
  

public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  virtual void on_public_data_changed();
  virtual void on_param_plugin_changed(Glib::RefPtr<Parameter> parameter);
  virtual void on_param_changed(Glib::RefPtr<Parameter> parameter);
  virtual void on_param_attr_changed(Glib::RefPtr<Parameter> parameter);
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Gda
} // namespace Gnome


namespace Glib
{
  /** @relates Gnome::Gda::ParameterList
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Glib::RefPtr<Gnome::Gda::ParameterList> wrap(GdaParameterList* object, bool take_copy = false);
}


#endif /* _LIBGDAMM_PARAMETERLIST_H */

