// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _LIBGDAMM_DICTFUNCTION_H
#define _LIBGDAMM_DICTFUNCTION_H


#include <glibmm.h>

/* $Id: dictfunction.hg,v 1.2 2006/11/08 00:07:37 murrayc Exp $ */
// -*- C++ -*- // this is for the .hg, I realize gensig puts one in

/* dictfunction.h
 *
 * Copyright 2006 libgdamm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or(at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <libgdamm/object.h>
#include <libgdamm/xmlstorage.h>
#include <libgdamm/dicttype.h>
#include <libgdamm/dict.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GdaDictFunction GdaDictFunction;
typedef struct _GdaDictFunctionClass GdaDictFunctionClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{ class DictFunction_Class; } // namespace Gda

} // namespace Gnome
namespace Gnome
{

namespace Gda
{

class Connection;

/** Represents a function in the DBMS.
 * DictFunction represents a function, with zero or more input parameters, and one and only one return type.
 * Therefore it does not represent procedures which do not return any data type. Also the argument types are always of 
 * the IN kind (no OUT or IN OUT arguments). There may one day be a specific object for procedures. Likewise, it does not 
 * represent a function returning a SET OF a given data type. There may one day be a specific object for such functions.
 *
 * Because functions can be polymorphic, the name is not enough to identify them, so the DBMS provides a unique id which 
 * can be used to uniquely identify a function. 
 * 
 * @ingroup Dictionaries
 */

class DictFunction
: public Gda::Object,
  public XmlStorage
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef DictFunction CppObjectType;
  typedef DictFunction_Class CppClassType;
  typedef GdaDictFunction BaseObjectType;
  typedef GdaDictFunctionClass BaseClassType;

private:  friend class DictFunction_Class;
  static CppClassType dictfunction_class_;

private:
  // noncopyable
  DictFunction(const DictFunction&);
  DictFunction& operator=(const DictFunction&);

protected:
  explicit DictFunction(const Glib::ConstructParams& construct_params);
  explicit DictFunction(GdaDictFunction* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~DictFunction();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GdaDictFunction*       gobj()       { return reinterpret_cast<GdaDictFunction*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GdaDictFunction* gobj() const { return reinterpret_cast<GdaDictFunction*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GdaDictFunction* gobj_copy();

private:

  
protected:

  explicit DictFunction(const Glib::RefPtr<Dict>& dict);

public:
  
  static Glib::RefPtr<DictFunction> create(const Glib::RefPtr<Dict>& dict);


  /** Set the DBMS identifier of the function
   * @param id The DBMS identifier.
   */
  void set_dbms_id(const Glib::ustring& id);
  
  /** Get the DBMS identifier of the function
   * @return A new string with the function's id.
   */
  Glib::ustring get_dbms_id() const;
  
  /** Set the SQL name of the data type.
   */
  void set_sqlname(const Glib::ustring& sqlname);
  
  /** Get the DBMS's name of a data type.
   * @return The name of the data type.
   */
  Glib::ustring get_sqlname() const;

  
  /** Set the arguments types of a function
   * @param arg_types A list of Gda::DictType objects or #<tt>0</tt> values ordered to represent the data types
   * of the function's arguments .
   */
  void set_arg_dict_types(const Glib::SListHandle<DictType>& arg_types);

 
  /** To consult the list of arguments types (and number) of a function.
   * @return A list of Gda::DictType objects, the list MUST NOT be modified.
   */
  Glib::SListHandle< Glib::RefPtr<const DictType> > get_arg_dict_types() const;
  
    
  /** Set the return type of a function
   * @param dt A Gda::DictType object or #<tt>0</tt>.
   */
  void set_ret_dict_type(const Glib::RefPtr<DictType>& dt);

  
  /** To consult the return type of a function.
   * @return A Gda::DictType object.
   */
  Glib::RefPtr<DictType> get_ret_dict_type();
  
  /** To consult the return type of a function.
   * @return A Gda::DictType object.
   */
  Glib::RefPtr<const DictType> get_ret_dict_type() const;

  
  /** Test if the proposed list of arguments ( @a arg_types ) would be accepted by
   * the @a func  function.
   * 
   * The non acceptance can be beause of data type incompatibilities or a wrong number
   * of data types.
   * @param arg_types A list of Gda::DictType objects or #<tt>0</tt> values, ordered.
   * @return <tt>true</tt> if accepted.
   */
  bool accepts_arg_dict_types(const Glib::SListHandle<DictType>& arg_types);


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Gda
} // namespace Gnome


namespace Glib
{
  /** @relates Gnome::Gda::DictFunction
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Glib::RefPtr<Gnome::Gda::DictFunction> wrap(GdaDictFunction* object, bool take_copy = false);
}


#endif /* _LIBGDAMM_DICTFUNCTION_H */

