#!/usr/bin/env python

from distutils.core import setup, Extension

setup(
    name="libgcrypt-py",
    version="0.1.0",
    description="A python wrapper for libgcrypt",
    author="Nat Tuck",
    author_email="nat@ferrus.net",
    url="http://libgcrypt-py.sourceforge.net",
    download_url="http://sourceforge.net/projects/libgcrypt-py/",
    py_modules=['Gcrypt'],
    ext_package="_Gcrypt",
    ext_modules=[
        Extension("_Cipher", ["_Gcrypt/ciphermodule.c"],
            libraries=["gcrypt", "gpg-error"]),
        Extension("_Hash", ["_Gcrypt/hashmodule.c"],
            libraries=["gcrypt", "gpg-error"]),
        Extension("_Random", ["_Gcrypt/randommodule.c"],
            libraries=["gcrypt", "gpg-error"]),
        Extension("_Pk", ["_Gcrypt/pkmodule.c"],
            libraries=["gcrypt", "gpg-error"]),
        ]
    )

