/* randommodule.c - part of libgcrypt-py
 * Copyright 2004 (C) Nat Tuck
  * Licenced under the GNU LGPL 2.1+, see COPYING.txt for details
   */

#include <Python.h>
#include <gcrypt.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

static PyObject * random_gen_weak (PyObject * self, PyObject * args) {
    unsigned int length;

    if (!PyArg_ParseTuple(args, "I", &length))
        return NULL; 

    unsigned char buffer[length];
    gcry_create_nonce(buffer, length);

    return Py_BuildValue("s#", buffer, length);
}

static PyObject * random_gen_medium (PyObject * self, PyObject * args) {
    unsigned int length;

    if (!PyArg_ParseTuple(args, "I", &length))
        return NULL; 

    unsigned char buffer[length];
    gcry_randomize(buffer, length, GCRY_STRONG_RANDOM);

    return Py_BuildValue("s#", buffer, length);
}

static PyObject * random_gen_strong (PyObject * self, PyObject * args) {
    unsigned int length;

    if (!PyArg_ParseTuple(args, "I", &length))
        return NULL; 

    unsigned char buffer[length];
    gcry_randomize(buffer, length, GCRY_VERY_STRONG_RANDOM);

    return Py_BuildValue("s#", buffer, length);
}

static PyMethodDef RandomMethods [] = {
    {"gen_weak", random_gen_weak, METH_VARARGS, "Generate some bytes."},
    {"gen_medium", random_gen_medium, METH_VARARGS, "Generate some bytes."},
    {"gen_strong", random_gen_strong, METH_VARARGS, "Generate some bytes."},
    {NULL, NULL, 0, NULL}
};

PyMODINIT_FUNC init_Random(void) {
    (void) Py_InitModule("_Random", RandomMethods);
}
