/* 
 * Copyright (c) 2006, Jakub Pavelek <jpavelek@welho.com>
 * All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *        documentation and/or other materials provided with the distribution.
 *     * Neither the name of Jakub Pavelek nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
 
#ifndef H_PID_UI
#define H_PID_UI

#include "pidinfo.h"
#include <stdio.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <string.h>

#define LOAD_DIALOG_ACCEPT 1
#define LOAD_DIALOG_CANCEL 2
#define LOAD_DIALOG_CLOSE 3
#define LOAD_DIALOG_KILL 4
#define LOAD_DIALOG_WATCH 5
#define LOAD_DIALOG_YES 6
#define LOAD_DIALOG_NO 7


/************************** Helper funtions ************************/

/**
 * Populates the process list store with process data read from
 * the process filesystem
 *
 * @return GtkListStore* containing the process info. Allocated.
 */
GtkListStore*
populate_store (void);



/************************* UI Callbacks **************************/

/**
 * Callback for "List processes" menu item. Shows the processes dialog
 *
 * @param item :the menu item. Not used
 * @param data :user data. Not used.
 */
void
activate_list_processes_item (GtkMenuItem *item, gpointer data);


/*
 *
 */
gboolean
pidui_update_load_detail (GtkTreeModel *, GtkTreePath *, GtkTreeIter *, gpointer);


#endif
