// this file is part of liqbase by Gary Birkett
		
#include <liqbase/liqbase.h>
#include <liqbase/liqcell.h>
#include <liqbase/liqcell_prop.h>
#include <liqbase/liqcell_easyrun.h>
#include <liqbase/liqcell_easyhandler.h>


#include <string.h>
#include <stdlib.h>
#include "liqcell_textrecordparse.h"

static int liqfont_wordwrap(liqfont *font, char *line,int availw,  int maxlinecount,       char **linestarts,int *lineoffsets,int *linelengths,   int *arglinecount,int *arglinewidest)
{
//##########################
// count all the lines	
int linecount=0;
int linewidest=0;
	char *c = line;					
	while(c && *c)
	{
		int tl = strlen(c);		// total length remaining
		int lc = liqfont_textfitinside(font, c, availw-16 );
		if(lc==0)lc++;
		liqapp_log("liqfont_wordwrap '%s' %i,%i",c,tl,lc);
		if(lc<tl)
		{
			int le = lc;
			while(le>0)
			{
				switch(c[le-1])
				{
					case ' ':
					case ',':
					case ';':
					case ':':
					case '.':
						le--;
						break;
					default:
						goto fin;
				}
			}
			fin:
			if(le>0)lc=le;
			while(c[lc]==' ')lc++;
		}
		linestarts[linecount] = c;
		lineoffsets[linecount] = c-line;
		linelengths[linecount] = lc;
		linecount++;
		if(linecount>=maxlinecount) break;
		if(lc>linewidest)linewidest=lc;
		c=&c[lc];
	}
	*arglinecount=linecount;
	*arglinewidest=linewidest;
	return linecount;
}

		
		
//#####################################################################
//#####################################################################
//##################################################################### messageitem :: by gary birkett
//#####################################################################
//#####################################################################
	
liqcell *make_nobble_url(liqcell *rec)
{
	// make a url type bobble :)
	
		liqcell *nobble;
		
		// image url?
		
		
		char *ext = liqapp_filename_walktoextension(rec->name);
		
		if( ext && *ext && ( (strcasecmp(ext,"png")==0) || (strcasecmp(ext,"jpg")==0) || (strcasecmp(ext,"jpeg")==0) ) )
		{
			// gulp!
			nobble = liqcell_quickcreatevis(rec->name, "nobble_url", 0, 0, 72,72);
			//liqcell_setcaption(nobble, "");
			liqcell_propsets(  nobble, "imagefilename", rec->name);
			//liqcell_propsets(  nobble, "backcolor", "rgb(20,70,10)");
			//liqcell_setfont(	nobble, liqfont_cache_getttf("/usr/share/fonts/nokia/nosnb.ttf", (18), 0) );
			liqcell_setvisible(nobble,1);
			
		}
		else
		{
			nobble = liqcell_quickcreatevis(rec->name, "nobble_url", 0, 0, 38,38);
			//liqcell_setcaption(nobble, "");
			liqcell_propsets(  nobble, "backcolor", "rgb(20,70,10)");
			liqcell_setfont(	nobble, liqfont_cache_getttf("/usr/share/fonts/nokia/nosnb.ttf", (18), 0) );
			liqcell_setvisible(nobble,1);
			
		}
		
		//liqcell_child_append(nobble,rec);
		liqcell_release(rec);// release it once we are done with it, no point in retaining everything :)
		return nobble;
}

liqcell *make_nobble_chan(liqcell *rec)
{
	// make a url type bobble :)
	
		liqcell *nobble = liqcell_quickcreatevis(rec->name, "nobble_chan", 0, 0, 38,38);
		//liqcell_setcaption(nobble, "");
		liqcell_propsets(  nobble, "backcolor", "rgb(20,10,80)");
		liqcell_setfont(	nobble, liqfont_cache_getttf("/usr/share/fonts/nokia/nosnb.ttf", (18), 0) );
		liqcell_setvisible(nobble,1);
		
		//liqcell_child_append(nobble,rec);
		liqcell_release(rec);
		return nobble;
}

liqcell *make_nobble_bug(liqcell *rec)
{
	// make a url type bobble :)
	
		liqcell *nobble = liqcell_quickcreatevis(rec->name, "nobble_bug", 0, 0, 38,38);
		//liqcell_setcaption(nobble, "");
		liqcell_propsets(  nobble, "backcolor", "rgb(80,20,10)");
		liqcell_setfont(	nobble, liqfont_cache_getttf("/usr/share/fonts/nokia/nosnb.ttf", (18), 0) );
		liqcell_setvisible(nobble,1);
		
		//liqcell_child_append(nobble,rec);
		liqcell_release(rec);
		return nobble;
}	
	
	
//#####################################################################
//#####################################################################
//#####################################################################
//#####################################################################
/**	
 * messageitem widget layout.
 */	
static int messageitem_layout(liqcell *self,liqcelleventargs *args, liqcell *context)
{
		liqapp_log("hello");
	liqcell *picicon = liqcell_child_lookup(self, "picicon");
	liqcell *txttext = liqcell_child_lookup(self, "txttext");
	liqcell *allnobbles = liqcell_child_lookup(self, "allnobbles");
	if(allnobbles)
	{
		liqapp_log("hello2");
		int allh=0;
		liqcell *n=liqcell_getlinkchild_visible(allnobbles);
		while(n)
		{
			if(n->h>allh)allh=n->h;
			n=liqcell_getlinknext_visible(n);
		}
		int cnt=liqcell_child_countvisible(allnobbles);
		if(cnt<4)cnt=4;
		

		liqcell_setsize(self,self->w,txttext->h+allh);
		liqcell_setsize(picicon,picicon->w,txttext->h);
		
		liqcell_setpos( allnobbles,txttext->x,txttext->h);
		liqcell_setsize(allnobbles,self->w,allh);
		
		liqcell_propseti(allnobbles,"arrange_usegracefulreduction",0);
		liqcell_child_arrange_makegrid(allnobbles, cnt,1);

	}
	else
	{
		liqapp_log("hello3");

		liqcell_setsize(self,self->w,txttext->h);
		liqcell_setsize(picicon,picicon->w,txttext->h);
	}	
}
		
		
/**	
 * messageitem widget refresh, all params set, present yourself to the user.
 */	
static int messageitem_refresh(liqcell *self,liqcelleventargs *args, liqcell *context)
{
	// there might be an OS level variable called filter
	// it should be set and adjusted correctly prior to calling this routine
	// you should do your best to account for this filter in any way you see fit


	liqcell *picicon = liqcell_child_lookup(self, "picicon");
	liqcell *txttext = liqcell_child_lookup(self, "txttext");


	char *auser    = liqcell_propgets(self,"user","");
	char *atext    = liqcell_propgets(self,"text","");


	liqcell_propsets_printf(picicon,"imagefilename","http://liqbase.net/get_maemo_user.php?user=%s",auser);
	

	//liqcell_setcaption(picicon,auser);
	liqcell_setcaption(txttext,atext);

	liqfont *font = liqcell_getfont(txttext);
	
	liqfont_setview(font,1,1);
	
	liqcell_setsize(txttext,self->w - picicon->w,txttext->h);
	
	
int lineheight = liqfont_textheight(font);
#define linemax 128
char *linestarts[linemax];
int lineoffsets[linemax];
int linelengths[linemax];
int linecount=0;
int linewidest=0;
	
	liqfont_wordwrap(font,atext,(txttext->w), linemax,  &linestarts[0],&lineoffsets[0],&linelengths[0],   &linecount,&linewidest);
	liqapp_log("test lh=%i    lc=%i",lineheight,linecount);
	//linecount++;
	if(linecount==0)linecount=1;
	liqcell_setsize(txttext,txttext->w,lineheight*linecount+4);
	liqcell_setsize(picicon,picicon->w,lineheight*linecount+4);
	liqcell_setsize(self,self->w,lineheight*linecount+4);

	liqcell_propseti(txttext,"wordwrap",1);
	liqcell_propseti(txttext,"cursorpos",0);		// set this to enable word wrap :)

	// search the message for anything we can nobblize
	
	
	
	
	void *add_nobble_from_record(liqcell *rec)
	{
		int sh=self->h;
		
		liqcell *allnobbles = liqcell_child_lookup(self, "allnobbles");
		if(!allnobbles)
		{


			//liqapp_log("GGG 0 self h=%i into %i   '%s'",sh,self->h,atext);
			
			allnobbles = liqcell_quickcreatevis("allnobbles", "picturebox", 56, self->h, self->w-56, 56);
			//liqcell_propsets(  allnobbles, "backcolor", "rgb(20,10,80)");
			liqcell_setsize(self,self->w,self->h+56);
			liqcell_setsize(picicon,picicon->w,self->h);
			liqcell_child_append(  self, allnobbles);
			
			
			//liqcell_propsets(  self, "backcolor", "rgb(140,10,80)");

			//liqapp_log("GGG 1 self h=%i into %i   '%s'",sh,self->h,atext);


		}

		liqcell *nobble = liqcell_quickcreatevis(rec->name, "picturebox", 0, 0, self->w/4, 38);
		liqcell_propsets(  nobble, "backcolor", "rgb(20,10,80)");
		liqcell_child_append(nobble,rec);
		liqcell_propsets(  nobble, "backcolor", "rgb(20,150,40)");
		liqcell_setfont(	nobble, liqfont_cache_getttf("/usr/share/fonts/nokia/nosnb.ttf", (18), 0) );
		liqcell_setvisible(nobble,1);
		
		liqcell_child_append(  allnobbles, nobble);

		//liqapp_log("GGG 2 self h=%i into %i   '%s'",sh,self->h,atext);
		
		int cnt=liqcell_child_countvisible(allnobbles);
		if(cnt<4)cnt=4;
		
		liqcell_propseti(allnobbles,"arrange_usegracefulreduction",0);

		liqcell_setsize(allnobbles, self->w-56, 56);
		liqcell_child_arrange_makegrid(allnobbles, cnt,1);
		liqcell_setsize(allnobbles, self->w-56, 56);


		//liqapp_log("GGG 3 self h=%i into %i   '%s'",sh,self->h,atext);

	}
	
	
	

	
	
	void *add_nobble_from_nobble(liqcell *nobble)
	{
		int sh=self->h;
		liqcell *allnobbles = liqcell_child_lookup(self, "allnobbles");
		if(!allnobbles)
		{
			allnobbles = liqcell_quickcreatevis("allnobbles", "picturebox", 56, self->h, self->w-56, 56);
			//liqcell_propsets(  allnobbles, "backcolor", "rgb(20,10,80)");
			liqcell_child_append(  self, allnobbles);
		}
		liqcell_child_append(  allnobbles, nobble);
	}
	


	
	char *cursor=atext;
	while(*cursor)
	{
		liqcell *rec=NULL;
		int nobblecnt=0;
	
		if( (rec=liqcell_textrecordparse(cursor,"https://[$url]")) ||
		    (rec=liqcell_textrecordparse(cursor,"http://[$url]")) ||
		    (rec=liqcell_textrecordparse(cursor,"ftp://[$url]")) ||
			(rec=liqcell_textrecordparse(cursor,"www.[$url]"))
		  )
		{
			nobblecnt++;
			cursor+=liqcell_propgeti(rec,"_len",1);
			add_nobble_from_nobble(  make_nobble_url(rec)  );
		}
		if( (rec=liqcell_textrecordparse(cursor,"bug [%id]")) ||
		    (rec=liqcell_textrecordparse(cursor,"bug[%id]")) ||
		    (rec=liqcell_textrecordparse(cursor,"bug #[%id]")) ||
		    (rec=liqcell_textrecordparse(cursor,"bug#[%id]")) ||
			(rec=liqcell_textrecordparse(cursor,"#[%id]"))
		  )
		{
			nobblecnt++;
			cursor+=liqcell_propgeti(rec,"_len",1);
			add_nobble_from_nobble(  make_nobble_bug(rec)  );
		}
		if(	(rec=liqcell_textrecordparse(cursor,"#[$chan]"))
		  )
		{
			nobblecnt++;
			cursor+=liqcell_propgeti(rec,"_len",1);
			add_nobble_from_nobble(  make_nobble_chan(rec)  );
		}
		//liqapp_log("trying cursor : '%s'",cursor);

		if(nobblecnt==0)
		{
			cursor++;
		}
	}

	liqcell_handlerrun(self,"layout",NULL);

	return 0;
}
/**	
 * messageitem dialog_open - the user zoomed into the dialog
 */	
static int messageitem_dialog_open(liqcell *self,liqcelleventargs *args, liqcell *contxttext)
{
	return 0;
}
/**	
 * messageitem dialog_close - the dialog was closed
 */	
static int messageitem_dialog_close(liqcell *self,liqcelleventargs *args, liqcell *contxttext)
{
	return 0;
}
/**	
 * messageitem widget shown - occurs once per lifetime
 */

static int messageitem_shown(liqcell *self,liqcelleventargs *args, liqcell *contxttext)
{
	//liqcell_handlerrun(self,"refresh",NULL);
	return 0;
}
/**	
 * messageitem mouse - occurs all the time as you stroke the screen
 */	
static int messageitem_mouse(liqcell *self, liqcellmouseeventargs *args,liqcell *contxttext)
{
	return 0;
}
/**	
 * messageitem click - occurs when a short mouse stroke occured
 */	
static int messageitem_click(liqcell *self, liqcelleventargs *args,liqcell *contxttext)
{
	return 0;
}
/**	
 * messageitem keypress - the user pressed a key
 */	
static int messageitem_keypress(liqcell *self, liqcellkeyeventargs *args,liqcell *contxttext)
{
	return 0;
}
/**	
 * messageitem keyrelease - the user released a key
 */	
static int messageitem_keyrelease(liqcell *self, liqcellkeyeventargs *args,liqcell *contxttext)
{
	return 0;
}
/**	
 * messageitem paint - being rendered.  use the vgraph held in args to do custom drawing at scale
 */	
//static int messageitem_paint(liqcell *self, liqcellpainteventargs *args,liqcell *contxttext)
//{
//	// big heavy event, use sparingly
//	return 0;
//}


/**	
 * messageitem dynamic resizing
 */	
static int messageitem_resize(liqcell *self,liqcelleventargs *args, liqcell *contxttext)
{
	float sx=((float)self->w)/((float)self->innerw);
	float sy=((float)self->h)/((float)self->innerh);
	
	liqcell *picicon = liqcell_child_lookup(self, "picicon");
	liqcell *txttext = liqcell_child_lookup(self, "txttext");
	liqcell_setrect_autoscale( picicon, 6,0, 38,38, sx,sy);
	liqcell_setrect_autoscale( txttext, 50,0, 542,38, sx,sy);
	return 0;
}



/**	
 * messageitem_child_test_seek this function shows how to access members
 */	
	  
static void messageitem_child_test_seek(liqcell *self)
{	  
	liqcell *resize1 = liqcell_child_lookup(self, "resize1");
	liqcell *picicon = liqcell_child_lookup(self, "picicon");
	liqcell *txttext = liqcell_child_lookup(self, "txttext");
}	  
/**	
 * create a new messageitem widget
 */	
liqcell *messageitem_create()
{
	liqcell *self = liqcell_quickcreatewidget("messageitem", "form", 598, 38);
	if(!self) {liqapp_log("liqcell error not create 'messageitem'"); return NULL;  } 
	
	// Optimization:  The aim is to REDUCE the number of drawn layers and operations called.
	// Optimization:  use only what you NEED to get an effect
	// Optimization:  Minimal layers and complexity
	// Optimization:  defaults: background, prefer nothing, will be shown through if there is a wallpaper
	// Optimization:  defaults: txttext, white, very fast rendering
	//############################# picicon:picturebox
	liqcell *picicon = liqcell_quickcreatevis("picicon", "picturebox", 6, 0, 38, 38);
	//liqcell_setfont(	picicon, liqfont_cache_getttf("/usr/share/fonts/nokia/nosnb.ttf", (12), 0) );
	//liqcell_propsets(  picicon, "textcolor", "rgb(0,0,0)" );
	//liqcell_propsets(  picicon, "backcolor", "rgb(128,128,128)" );
	//liqcell_propsets(  picicon, "bordercolor", "rgb(255,255,255)" );
	liqcell_child_append(  self, picicon);
	//############################# txttext:label
	liqcell *txttext = liqcell_quickcreatevis("txttext", "label", 50, 0, 542, 38);
	liqcell_setfont(	txttext, liqfont_cache_getttf("/usr/share/fonts/nokia/nosnb.ttf", (18), 0) );
	liqcell_setcaption(txttext, "messagetext" );
	liqcell_propsets(  txttext, "textcolor", "rgb(255,255,255)" );
	//liqcell_propsets(  txttext, "backcolor", "rgb(128,128,128)" );
	liqcell_propseti(  txttext, "textalign", 0 );
	liqcell_child_append(  self, txttext);
	//liqcell_propsets(  self, "backcolor", "rgb(64,64,64)" );
	liqcell_handleradd_withcontext(self, "refresh", messageitem_refresh ,self);
	liqcell_handleradd_withcontext(self, "shown", messageitem_shown ,self);
	liqcell_handleradd_withcontext(self, "layout", messageitem_layout ,self);
	//liqcell_handleradd_withcontext(self, "keypress", messageitem_keypress,self );
	//liqcell_handleradd_withcontext(self, "keyrelease", messageitem_keyrelease ,self);
	//liqcell_handleradd_withcontext(self, "mouse", messageitem_mouse,self );
	//liqcell_handleradd_withcontext(self, "click", messageitem_click ,self);
	//liqcell_handleradd_withcontext(self, "paint", messageitem_paint ,self); // use only if required, heavyweight
	liqcell_handleradd_withcontext(self, "dialog_open", messageitem_dialog_open ,self);
	liqcell_handleradd_withcontext(self, "dialog_close", messageitem_dialog_close ,self);
	return self;
}

