// this file is part of liqbase by Gary Birkett
		
#include <liqbase/liqbase.h>
#include <liqbase/liqcell.h>
#include <liqbase/liqcell_prop.h>
#include <liqbase/liqcell_easyrun.h>
#include <liqbase/liqcell_easyhandler.h>
		
		
void liqirc_sendserv(liqcell *liqirc,char *str, ...);



// liqircchan is actually chanmanage
// it holds everything for a single chan
// whether a public chan or a privte conversation

// the irc server exists in the parent list and messages are bubbled into the correct component as required.

		
//#####################################################################
//#####################################################################
//##################################################################### liqircchan :: by gary birkett
//#####################################################################
//#####################################################################
		
int liqircchan_additem(liqcell *liqircchan,char *time,char *user,char *message)
{
	liqcell *liqirc1 = liqcell_getdata(liqircchan);
	liqcell *userlist1 = liqcell_child_lookup(liqircchan, "userlist1");
	liqcell *messagelist1 = liqcell_child_lookup(liqircchan, "messagelist1");
	liqcell *txtmessage = liqcell_child_lookup(liqircchan, "txtmessage");
	liqcell *cmdsubmit = liqcell_child_lookup(liqircchan, "cmdsubmit");
	liqcell *title = liqcell_child_lookup(liqircchan, "title");
	liqcell *liqircdraw1 = liqcell_child_lookup(liqircchan, "liqircdraw1");
	
	//liqcell *liqirc1 = liqcell_getdata(liqircchan);
	
	liqcell_setcaption(title, liqcell_getname(liqircchan));

	//liqcell_setcaption(liqircdraw1, liqcell_getname(liqircchan));
	liqcell_propsets(liqircdraw1,"chan",liqcell_getname(liqircchan));
	liqcell_setdata(liqircdraw1,liqirc1);

	messagelist_additem(messagelist1,time,user,message);
}
		
		
/**	
 * liqircchan widget refresh, all params set, present yourself to the user.
 */	
static int liqircchan_refresh(liqcell *self,liqcelleventargs *args, liqcell *context)
{
	// there might be an OS level variable called filter
	// it should be set and adjusted correctly prior to calling this routine
	// you should do your best to account for this filter in any way you see fit
	return 0;
}


/**	
 * liqircchan dialog_open - the user zoomed into the dialog
 */	
static int liqircchan_dialog_open(liqcell *self,liqcelleventargs *args, liqcell *context)
{
	return 0;
}
/**	
 * liqircchan dialog_close - the dialog was closed
 */	
static int liqircchan_dialog_close(liqcell *self,liqcelleventargs *args, liqcell *context)
{
	return 0;
}
/**	
 * liqircchan widget shown - occurs once per lifetime
 */	
static int liqircchan_shown(liqcell *self,liqcelleventargs *args, liqcell *context)
{
	return 0;
}
/**	
 * liqircchan mouse - occurs all the time as you stroke the screen
 */	
static int liqircchan_mouse(liqcell *self, liqcellmouseeventargs *args,liqcell *context)
{
	return 0;
}
/**	
 * liqircchan click - occurs when a short mouse stroke occured
 */	
static int liqircchan_click(liqcell *self, liqcelleventargs *args,liqcell *context)
{
	return 0;
}
/**	
 * liqircchan keypress - the user pressed a key
 */	
static int liqircchan_keypress(liqcell *self, liqcellkeyeventargs *args,liqcell *context)
{
	return 0;
}
/**	
 * liqircchan keyrelease - the user released a key
 */	
static int liqircchan_keyrelease(liqcell *self, liqcellkeyeventargs *args,liqcell *context)
{
	return 0;
}
/**	
 * liqircchan paint - being rendered.  use the vgraph held in args to do custom drawing at scale
 */	
//static int liqircchan_paint(liqcell *self, liqcellpainteventargs *args,liqcell *context)
//{
//	// big heavy event, use sparingly
//	return 0;
//}
/**	
 * liqircchan dynamic resizing
 */
/*
static int liqircchan_resize(liqcell *self,liqcelleventargs *args, liqcell *context)
{
	float sx=((float)self->w)/((float)self->innerw);
	float sy=((float)self->h)/((float)self->innerh);
	
	liqcell *userlist1 = liqcell_child_lookup(self, "userlist1");
	liqcell *messagelist1 = liqcell_child_lookup(self, "messagelist1");
	liqcell *txtmessage = liqcell_child_lookup(self, "txtmessage");
	liqcell *cmdsubmit = liqcell_child_lookup(self, "cmdsubmit");
	liqcell *title = liqcell_child_lookup(self, "title");

	liqcell_setrect_autoscale( userlist1, 698,38, 102,384, sx,sy);
	liqcell_setrect_autoscale( messagelist1, 0,38, 696,384, sx,sy);
	liqcell_setrect_autoscale( txtmessage, 56,424, 642,56, sx,sy);
	liqcell_setrect_autoscale( cmdsubmit, 698,424, 102,56, sx,sy);
	liqcell_setrect_autoscale( title, 0,0, 800,38, sx,sy);
	return 0;
}
 */

/**	
 * liqircchan.cmddrawtoggle clicked
 */	
static int cmddrawtoggle_click(liqcell *self,liqcelleventargs *args, liqcell *liqircchan)
{
	return 0;
}

/**	
 * liqircchan.cmdsubmit clicked
 */	
static int cmdsubmit_click(liqcell *self,liqcelleventargs *args, liqcell *liqircchan)
{
	liqcell *userlist1 = liqcell_child_lookup(liqircchan, "userlist1");
	liqcell *messagelist1 = liqcell_child_lookup(liqircchan, "messagelist1");
	liqcell *txtmessage = liqcell_child_lookup(liqircchan, "txtmessage");
	liqcell *cmdsubmit = liqcell_child_lookup(liqircchan, "cmdsubmit");
	liqcell *title = liqcell_child_lookup(liqircchan, "title");
	
	liqcell *liqirc1 = liqcell_getdata(liqircchan);
	liqapp_log("message.submit adding");
	
	char *msg = liqcell_getcaption(txtmessage);
	
	if(!msg || !*msg)
	{
		// nothing to show or send
		return -1;
	}
	
	messagelist_additem(messagelist1, "00:00", "gary", liqcell_getcaption(txtmessage) );
	
	
	char buf[1024];
	snprintf(buf,sizeof(buf),"PRIVMSG %s :%s",liqcell_getname(liqircchan), liqcell_getcaption(txtmessage) );
	liqirc_sendserv(liqirc1,buf);
	
	
	liqapp_log("message.submit clearing");
	
	liqcell_setcaption(txtmessage,"");
	//textbox_selectall(txtmessage);
	return 0;
}




/**	
 * txtmessage keypress_enter - the user pressed enter key on this textbox
 */	
static int txtmessage_keypress_enter(liqcell *self, liqcellkeyeventargs *args,liqcell *context)
{
	liqcell *cmdsubmit = liqcell_child_lookup(self, "cmdsubmit");
	liqcell_handlerrun(cmdsubmit,"click",NULL);
	return 0;
}

/**	
 * liqircchan_child_test_seek this function shows how to access members
 */	
	  
static void liqircchan_child_test_seek(liqcell *self)
{	  
	liqcell *userlist1 = liqcell_child_lookup(self, "userlist1");
	liqcell *messagelist1 = liqcell_child_lookup(self, "messagelist1");
	liqcell *txtmessage = liqcell_child_lookup(self, "txtmessage");
	liqcell *cmdsubmit = liqcell_child_lookup(self, "cmdsubmit");
	liqcell *title = liqcell_child_lookup(self, "title");
}	  
/**	
 * create a new liqircchan widget
 */	
liqcell *liqircchan_create()
{
	liqcell *self = liqcell_quickcreatewidget("liqircchan", "form", 800, 480);
	if(!self) {liqapp_log("liqcell error not create 'liqircchan'"); return NULL;  } 

	
	// Optimization:  The aim is to REDUCE the number of drawn layers and operations called.
	// Optimization:  use only what you NEED to get an effect
	// Optimization:  Minimal layers and complexity
	// Optimization:  defaults: background, prefer nothing, will be shown through if there is a wallpaper
	// Optimization:  defaults: text, white, very fast rendering

	//############################# messagelist1:messagelist
	liqcell *messagelist1 = liqcell_quickcreatevis("messagelist1", "messagelist", 0, 38, 698, 384);
	liqcell_child_append(  self, messagelist1);

	//############################# userlist1:userlist
	liqcell *userlist1 = liqcell_quickcreatevis("userlist1", "userlist", 698, 38, 102, 384);
	liqcell_child_append(  self, userlist1);
	
	//############################# txtmessage:textbox
	liqcell *txtmessage = liqcell_quickcreatevis("txtmessage", "textbox", 56, 424, 642, 56);
	liqcell_setfont(	txtmessage, liqfont_cache_getttf("/usr/share/fonts/nokia/nosnb.ttf", (33), 0) );
	liqcell_setcaption(txtmessage, "" );
	liqcell_propsets(  txtmessage, "textcolor", "rgb(255,255,0)" );
	liqcell_propsets(  txtmessage, "backcolor", "rgb(0,0,64)" );
	liqcell_propsets(  txtmessage, "bordercolor", "rgb(200,100,100)" );
	liqcell_propseti(  txtmessage, "textalign", 0 );
	liqcell_propseti(  txtmessage, "textaligny", 2 );
	liqcell_handleradd_withcontext(txtmessage, "keypress_enter", txtmessage_keypress_enter,self );
	liqcell_child_append(  self, txtmessage);
	
	
	textbox_selectall(txtmessage);
	
	//############################# cmddrawtoggle:label
	liqcell *cmddrawtoggle = liqcell_quickcreatevis("cmddrawtoggle", "label", 698, 424-56, 102, 56);
	liqcell_setfont(	cmddrawtoggle, liqfont_cache_getttf("/usr/share/fonts/nokia/nosnb.ttf", (24), 0) );
	liqcell_setcaption(cmddrawtoggle, "Draw" );
	liqcell_propsets(  cmddrawtoggle, "textcolor", "rgb(255,255,255)" );
	liqcell_propsets(  cmddrawtoggle, "backcolor", "xrgb(0,128,128)" );
	liqcell_propsets(  cmddrawtoggle, "bordercolor", "rgb(255,255,255)" );
	liqcell_propseti(  cmddrawtoggle, "textalign",  2 );
	liqcell_propseti(  cmddrawtoggle, "textaligny", 2 );
	liqcell_handleradd_withcontext(cmddrawtoggle, "click", cmddrawtoggle_click, self );
	liqcell_child_append(  self, cmddrawtoggle);
	

	//############################# cmdsubmit:label
	liqcell *cmdsubmit = liqcell_quickcreatevis("cmdsubmit", "label", 698, 424, 102, 56);
	liqcell_setfont(	cmdsubmit, liqfont_cache_getttf("/usr/share/fonts/nokia/nosnb.ttf", (24), 0) );
	liqcell_setcaption(cmdsubmit, "Submit" );
	liqcell_propsets(  cmdsubmit, "textcolor", "rgb(255,255,255)" );
	liqcell_propsets(  cmdsubmit, "backcolor", "xrgb(0,128,0)" );
	liqcell_propsets(  cmdsubmit, "bordercolor", "rgb(255,255,255)" );
	liqcell_propseti(  cmdsubmit, "textalign",  2 );
	liqcell_propseti(  cmdsubmit, "textaligny", 2 );
	liqcell_handleradd_withcontext(cmdsubmit, "click", cmdsubmit_click, self );
	liqcell_child_append(  self, cmdsubmit);
		
	//############################# title:label
	liqcell *title = liqcell_quickcreatevis("title", "label", 0, 0, 800, 38);
	liqcell_setfont(	title, liqfont_cache_getttf("/usr/share/fonts/nokia/nosnb.ttf", (24), 0) );
	liqcell_setcaption(title, "liqtactoe" );
	liqcell_propsets(  title, "textcolor", "rgb(255,255,255)" );
	liqcell_propsets(  title, "backcolor", "xrgb(0,64,64)" );
	liqcell_propseti(  title, "textalign", 0 );
	liqcell_child_append(  self, title);
	
	//############################# liqircdraw1:userlist
	liqcell *liqircdraw1 = liqcell_quickcreatevis("liqircdraw1", "liqircdraw", 400,38, 400,384);
	liqcell_child_append(  self, liqircdraw1);


	//liqcell_propsets(  self, "backcolor", "rgb(0,0,0)" );
	liqcell_handleradd_withcontext(self, "refresh", liqircchan_refresh ,self);
	liqcell_handleradd_withcontext(self, "shown", liqircchan_shown ,self);
	//liqcell_handleradd_withcontext(self, "resize", liqircchan_resize ,self);
	//liqcell_handleradd_withcontext(self, "keypress", liqircchan_keypress,self );
	//liqcell_handleradd_withcontext(self, "keyrelease", liqircchan_keyrelease ,self);
	liqcell_handleradd_withcontext(self, "mouse", liqircchan_mouse,self );
	liqcell_handleradd_withcontext(self, "click", liqircchan_click ,self);
	//liqcell_handleradd_withcontext(self, "paint", liqircchan_paint ,self); // use only if required, heavyweight
	liqcell_handleradd_withcontext(self, "dialog_open", liqircchan_dialog_open ,self);
	liqcell_handleradd_withcontext(self, "dialog_close", liqircchan_dialog_close ,self);
	return self;
}

