import gtk
import time
try:
    import hildon
    usehildon=True
except:
    usehildon=False

class DistanceCalc:
    def __init__(self):
        self.window = gtk.Window()
        self.window.set_title("Lightning Distance Calculator")
        self.v1 = gtk.VBox()
        self.h1 = gtk.HBox()
        self.v2 = gtk.VBox()
        self.h2 = gtk.HBox()
        self.button = gtk.Button("Tap when you see it!")
        self.dlabel = gtk.Label("Distance: ")
        self.v1.add(self.h1)
        self.v1.add(self.button)
        self.v1.add(self.dlabel)
        self.h2.add(gtk.Label("Speed of sound:"))
        self.msadj = gtk.Adjustment(330,300,400,1,10) #This is the adjustment for m/s
        self.ftsadj = gtk.Adjustment(1082,984,1313,1,10) #This is the adjustment for ft/s
        self.mphadj = gtk.Adjustment(738,671,895,1,10) #This is the adjustment for mph
        # These are all based off m/s... which reall should be in the 330-350 range, but you can go
        # Outside that for our purposes... Changed ft/min to mph
        self.speed = gtk.SpinButton(self.msadj)
        self.r1 = gtk.RadioButton(None, "m/s")
        self.r2 = gtk.RadioButton(self.r1, "ft/s")
        self.r3 = gtk.RadioButton(self.r1, "mph")
        self.h2.add(self.speed)
        self.v2.add(self.h2)
        self.calc = gtk.Button("Calculate!")
        self.v2.add(self.calc)
        self.h1.add(self.v2)
        self.h1.add(self.r1)
        self.h1.add(self.r2)
        self.h1.add(self.r3)
        self.window.add(self.v1)
        self.window.show_all()
        self.window.connect("destroy", gtk.main_quit)
        self.handler = self.button.connect("clicked", self.rec_l)
        self.cur_units = "m/s"
        self.r1.connect("toggled", self.toggle_ms)
        self.r2.connect("toggled", self.toggle_fts)
        self.r3.connect("toggled", self.toggle_mph)
        self.calc.connect("clicked", self.open_calc)

    def toggle_ms(self,radio):
        if radio.get_active() == True:
            if self.cur_units == "ft/s":
                # We need to convert from ft/s --> m/s
                val = self.speed.get_value()
                newval = val/3.2808399
            elif self.cur_units == "mph":
                # We need to convert from mph --> m/s
                val = self.speed.get_value()
                newval = (val*1609.344)/(60.0*60.0)
            else:
                # m/s --> m/s ?
                newval = self.speed.get_value()
            self.speed.set_adjustment(self.msadj)
            self.speed.set_value(newval)
            self.cur_units = "m/s"

    def toggle_fts(self,radio):
        if radio.get_active() == True:
            if self.cur_units == "ft/s":
                # ft/s --> ft/s ?
                newval = self.speed.get_value()
            elif self.cur_units == "mph":
                # mph --> ft/s
                val = self.speed.get_value()
                newval = (val*5280.0)/(60.0*60.0)
            else:
                # m/s --> ft/s
                val = self.speed.get_value()
                newval = val*3.2808399
            self.speed.set_adjustment(self.ftsadj)
            self.speed.set_value(newval)
            self.cur_units = "ft/s"

    def toggle_mph(self,radio):
        if radio.get_active() == True:
            if self.cur_units == "ft/s":
                # ft/s --> mph
                val = self.speed.get_value()
                newval = (val*60.0*60.0)/5280.0
            elif self.cur_units == "mph":
                # mph --> mph
                newval = self.speed.get_value()
            else:
                # m/s --> mph
                val = self.speed.get_value()
                newval = (val*60.0*60.0)/1609.344
            self.speed.set_adjustment(self.mphadj)
            self.speed.set_value(newval)
            self.cur_units = "mph"

    def rec_l(self,button):
        #print "rec_l"
        self.time_l = time.time()
        button.set_label("Tap when you hear it!")
        button.disconnect(self.handler)
        self.handler = button.connect("clicked", self.rec_s)

    def rec_s(self,button):
        #print "rec_s"
        self.time_s = time.time()
        diff = self.time_s-self.time_l
        if self.cur_units == "mph":
            #With mph, we need to convert this to hours...
            diff = diff/(60.0*60.0)
            units = "miles"
        elif self.cur_units == "ft/s":
            units = "feet"
        else:
            units = "meters"
        dist = diff*self.speed.get_value()
        self.dlabel.set_text("Distance: %0.2f %s" % (dist,units))
        button.set_label("Tap when you see it!")
        button.disconnect(self.handler)
        self.handler = button.connect("clicked", self.rec_l)
        self.time_l = 0
        self.time_s = 0

    def open_calc(self,button):
        dialog = gtk.Dialog("Calculate Speed of Sound")
        content = dialog.get_child()
        hbox = gtk.HBox()
        content.pack_start(hbox)
        hbox.add(gtk.Label("Temperature: "))
        spin = gtk.SpinButton(gtk.Adjustment(70,-40,150,1,10))
        hbox.add(spin)
        dialog.add_button(u"\u00b0 C",1)
        dialog.add_button(u"\u00b0 F",2)
        dialog.add_button("Cancel", 3)
        hbox.show_all()
        def resp(dialog,resp,spin,units,speed):
            if resp == 2:
                #We were given a F temperature --> Convert to K
                degk = (spin.get_value()-32.0)*0.57+273.15
            elif resp == 1:
                #We were given a C temperature --> Convert to K
                degk = spin.get_value()+273.15
            if resp <> 3:
                knots = 643.855*((degk/273.15)**0.5) # <-- In Knots
                if units == "m/s":
                    # Convert Knots to m/s
                    speed.set_value(0.5144444*knots)
                elif units == "ft/s":
                    # Convert Knots to ft/s
                    speed.set_value(1.6878099*knots)
                elif units == "mph":
                    # Convert Knots to mph
                    speed.set_value(1.852*knots)
            dialog.destroy()
        dialog.connect("response", resp, spin, self.cur_units, self.speed)
        dialog.run()

handle = DistanceCalc()
gtk.main()