/*
  kwarto "Woods" tile set
*/

#include "colors.inc"    
#include "textures.inc"
#include "woods.inc"
#include "stones.inc"

background { color White }

light_source { <20, 30, -50> color White }

camera {
  location <0, -0, -5.245>
  look_at <0, 0, 0>
  right x*1
}

#declare LightWood = 
    texture { pigment { P_WoodGrain10A color_map { M_Wood7A }}}
    texture { pigment { P_WoodGrain10B color_map { M_Wood7B }}}

#declare DarkWood = 
    texture { pigment { P_WoodGrain10A color_map { M_Wood8A }}}
    texture { pigment { P_WoodGrain10B color_map { M_Wood8B }}}

#declare solid_disc = union {
     cylinder { <0, 0, -0.5>, <0, 0, 0.5>, 2 }
     torus { 2.0 0.5 rotate <90,0,0> }
   }

#declare hollow_disc = union {
     difference {
       object { solid_disc }
       cylinder { <0, 0, -1>, <0, 0, 0>, 1.5 }
     }
     torus { 1.5 0.5 rotate <90,0,0> }
  }  

#declare solid_square = union {
     box { <-2, -2, -0.5>, <2, 2, 0.5> }

     cylinder { <0,0,-2>, <0,0,2>, 0.5 rotate <90,0,0> translate <-2,0,0> }
     cylinder { <0,0,-2>, <0,0,2>, 0.5 rotate <90,0,0> translate < 2,0,0> }
     cylinder { <0,0,-2>, <0,0,2>, 0.5 rotate <0,90,0> translate <0,-2,0> }
     cylinder { <0,0,-2>, <0,0,2>, 0.5 rotate <0,90,0> translate <0, 2,0> }

     sphere { <-2,-2,0>, 0.5 }
     sphere { < 2,-2,0>, 0.5 }
     sphere { <-2, 2,0>, 0.5 }
     sphere { < 2, 2,0>, 0.5 }
   }

#declare hollow_square = union {
     difference {
       object { solid_square }
       box { <-1.5, -1.5, -1>, <1.5, 1.5, 0> }
     }
     cylinder { <0,0,-1.5>,<0,0,1.5>, 0.5 rotate<90,0,0> translate<-1.5,0,0> }
     cylinder { <0,0,-1.5>,<0,0,1.5>, 0.5 rotate<90,0,0> translate< 1.5,0,0> }
     cylinder { <0,0,-1.5>,<0,0,1.5>, 0.5 rotate<0,90,0> translate<0, 1.5,0> }
     cylinder { <0,0,-1.5>,<0,0,1.5>, 0.5 rotate<0,90,0> translate<0,-1.5,0> }
  }  

object {
#switch(mod(frame_number,4))
#case (0)
  solid_square
#break
#case (1)
  hollow_square
#break
#case (2)
  solid_disc 
#break
#case (3)
  hollow_disc
#break
#end


#if(mod(int(frame_number/8),2) = 0)
scale 0.6666
#end

#switch(mod(int(frame_number/4),2))
#case(0)
    texture { LightWood translate <0.1,0.1,0.1> rotate <110, 150*frame_number, 0> scale 3}
    finish { specular 0.5  roughness 0.0025 }
#break

#case(1)
    texture { DarkWood translate <0.1,0.1,0.1> rotate <110, 150*frame_number, 0> scale 3}
    finish { specular 0.5  roughness 0.0025 }
#break
#end

}
