/*
  kwarto "Stones" tile set
*/

#include "colors.inc"    
#include "textures.inc"
#include "stones.inc"

#include "tile.inc"

background { color White }

light_source { <200, 300, -500> color White }

camera {
  location <0, -0, -5.4>
//  location <0, -6, -2>
  look_at <0, 0, 0>
  right x*1
}

// plane { <0,0,1> 0.25  pigment { color rgb <2,2,2> } }

object {
#switch(mod(frame_number,4))
#case (0)
  solid_square
#break
#case (1)
  hollow_square
#break
#case (2)
  solid_disc 
#break
#case (3)
  hollow_disc
#break
#end

#if(mod(int(frame_number/8),2) = 0)
scale 0.7
#end

#switch(mod(int(frame_number/4),2))
#case(0)
    texture { T_Stone18 translate <0.1,0.1,0.1> rotate <110, 150*frame_number, 0> scale 3}
    finish { specular 0.5  roughness 0.0025 }
#break

#case(1)
    texture { T_Stone21 translate <0.1,0.1,0.1> rotate <110, 150*frame_number, 0> scale 3}
    finish { specular 0.5  roughness 0.0025 }
#break
#end

}
