#ifndef TILESET_H
#define TILESET_H

#include "game.h"

typedef struct {
  char name[33];        // name of tileset
  GtkImage *board;      // board image
  GtkImage *empty;      // board image
  GtkImage *tile[16];   // all tiles
  int offset;           // placement offset of tiles within board
} tileset_t;

extern void tileset_load(tileset_t *tileset);
extern void tileset_draw_tile(tileset_t *tileset, int tile, int xc, int yc);
extern void tileset_get_slot(tileset_t *tileset, int mx, int my, int *sx, int *sy);
extern void tileset_reload(tileset_t *tileset);

#endif // TILESET_H
