/*
 * menu.c
 */

#include <gtk/gtk.h>
#include <ctype.h>

#include "appdata.h"
#include "menu.h"
#include "statusbar.h"

#include <libintl.h>
#define _(x)  gettext(x)

const char help_text[] = 
"Kwarto is the maemo port of the Quarto two player board game. The\n"
"game consists of a board with 4x4 spaces and a set of 16 tiles. The\n"
"tiles have four attributes with two states each (e.g. small/big,\n"
"light/dark, hollow/solid and, round/square). These tiles are placed\n"
"onto the board one after the other. One player starts by selecting\n"
"one arbitrary tile which the other player in turn has to place at\n"
"whatever free space on the board it wants to. That player then\n"
"selects the next tile which the first player then has to place\n"
"This goes on until the game ends. The game ends if one player\n"
"manages to build a horizontal, vertical or diagonal line of four\n"
"tiles with at least one attribute in the same state (e.g. all four\n"
"tiles in the row are \"small\"). This player then wins. If the two\n"
"players manage to fill the entire board without winning situation\n"
"it's a draw game.";

static void 
cb_menu_help(GtkWidget *window, gpointer data) {
  appdata_t *appdata = (appdata_t*)data;
#if 0
  GtkWidget *dialog, *text_view, *scroll;
  GtkTextBuffer *buffer;

  dialog = gtk_dialog_new_with_buttons ("Message",
					GTK_WINDOW(appdata->window),
					GTK_DIALOG_DESTROY_WITH_PARENT,
					GTK_STOCK_OK,
					GTK_RESPONSE_NONE,
					NULL);

  /* give the dialog some size */
  gtk_window_set_default_size(GTK_WINDOW(dialog), 600,380);

  scroll = gtk_scrolled_window_new(NULL, NULL);
  text_view = gtk_text_view_new();
  buffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(text_view));
  gtk_text_buffer_set_text(buffer, help_text, -1);
  
  gtk_container_add(GTK_CONTAINER(scroll), text_view);
  gtk_container_add(GTK_CONTAINER(GTK_DIALOG(dialog)->vbox), scroll);
  gtk_widget_show_all(dialog);
  gtk_dialog_run(GTK_DIALOG(dialog));
  gtk_widget_destroy(GTK_WIDGET(dialog));
#endif
}

static void 
cb_menu_about(GtkWidget *window, gpointer data) {
  char name[] = APPNAME;
  name[0] = toupper(name[0]);

  GtkAboutDialog *about = GTK_ABOUT_DIALOG(gtk_about_dialog_new());

  gtk_about_dialog_set_name(about, name);
  gtk_about_dialog_set_version(about, APPVER);
  gtk_about_dialog_set_copyright(about, 
         "Maemo Kwarto (c) 2007 by\n" 
	 "Till Harbaum <till@harbaum.org>\n");

  gtk_about_dialog_set_website(about,
       "http://www.harbaum.org/till/maemo");
  
  gtk_about_dialog_set_comments(about, 
       "Maemo version of the Quarto game");

  gtk_widget_show_all(GTK_WIDGET(about));
  gtk_dialog_run(GTK_DIALOG(about));
  gtk_widget_destroy(GTK_WIDGET(about));
}

static gboolean
cb_menu_new(GtkWidget *widget, gpointer data) {  
  GtkWidget *dialog;
  appdata_t *appdata = (appdata_t*)data;
  int ret;

  dialog = gtk_message_dialog_new (GTK_WINDOW(appdata->window),
				   GTK_DIALOG_DESTROY_WITH_PARENT,
				   GTK_MESSAGE_QUESTION,
				   GTK_BUTTONS_NONE,
				   "Who should begin?");
  
  gtk_dialog_add_buttons(GTK_DIALOG(dialog), 
	 "CPU", 1, "Human", 2, "Cancel", 3, NULL);
  ret = gtk_dialog_run (GTK_DIALOG (dialog));
  gtk_widget_destroy (dialog);

  /* restart game engine and gui */
  if((ret == 1) || (ret == 2)) {
    game_restart(appdata->game);
    tileset_reload(appdata->tileset);
    selected_remove(appdata->selected);
    stack_update(appdata->stack);
  }

  if(ret == 1) {
    appdata->game->state = STATE_CPU_SELECTS;
    statusbar_message_state(appdata->statusbar);
 
    /* send signal to main window ... */
    g_signal_emit_by_name(G_OBJECT(appdata->window), "cpu_selects");
   }

  if(ret == 2) {
    appdata->game->state = STATE_HUMAN_SELECTS;
    statusbar_message_state(appdata->statusbar);
  }

  return TRUE;
}

static gboolean
cb_menu_exit(GtkWidget *widget, gpointer data) {  
  extern void game_quit(GtkWidget *widget, GdkEvent *event, gpointer data);

  game_quit(NULL, NULL, data);

  return TRUE;
}

void menu_create(appdata_t *appdata) { 
  GtkWidget *menu, *item;  
  menu = gtk_menu_new();

  item = gtk_menu_item_new_with_label( _("New...") );
  gtk_menu_append(GTK_MENU_SHELL(menu), item);
  g_signal_connect(item, "activate", GTK_SIGNAL_FUNC(cb_menu_new), appdata);

  gtk_menu_append(GTK_MENU_SHELL(menu), gtk_separator_menu_item_new());
  item = gtk_menu_item_new_with_label( _("Help...") );
  gtk_menu_append(GTK_MENU_SHELL(menu), item);
  g_signal_connect(item, "activate", GTK_SIGNAL_FUNC(cb_menu_help), appdata);
  item = gtk_menu_item_new_with_label( _("About...") );
  gtk_menu_append(GTK_MENU_SHELL(menu), item);
  g_signal_connect(item, "activate", GTK_SIGNAL_FUNC(cb_menu_about), NULL);
  item = gtk_menu_item_new_with_label( _("Close") );
  gtk_menu_append(GTK_MENU_SHELL(menu), item);
  g_signal_connect(item, "activate", GTK_SIGNAL_FUNC(cb_menu_exit), appdata);

  hildon_window_set_menu(appdata->window, GTK_MENU(menu));
}
