/*
  icon is derived from stones tile set
*/

#include "colors.inc"    
#include "textures.inc"
#include "stones.inc"

background { color White }

light_source { <200, 300, -500> color White }

camera {
  location <0, -0, -5.4>
  look_at <0, 0, 0>
  right x*1
}
#declare solid_square = union {
     box { <-2, -2, -0.5>, <2, 2, 0.5> }

     cylinder { <0,0,-2>, <0,0,2>, 0.5 rotate <90,0,0> translate <-2,0,0> }
     cylinder { <0,0,-2>, <0,0,2>, 0.5 rotate <90,0,0> translate < 2,0,0> }
     cylinder { <0,0,-2>, <0,0,2>, 0.5 rotate <0,90,0> translate <0,-2,0> }
     cylinder { <0,0,-2>, <0,0,2>, 0.5 rotate <0,90,0> translate <0, 2,0> }

     sphere { <-2,-2,0>, 0.5 }
     sphere { < 2,-2,0>, 0.5 }
     sphere { <-2, 2,0>, 0.5 }
     sphere { < 2, 2,0>, 0.5 }
   }

#declare hollow_square = union {
     difference {
       object { solid_square }
       box { <-1.5, -1.5, -1>, <1.5, 1.5, 0> }
     }
     cylinder { <0,0,-1.5>,<0,0,1.5>, 0.5 rotate<90,0,0> translate<-1.5,0,0> }
     cylinder { <0,0,-1.5>,<0,0,1.5>, 0.5 rotate<90,0,0> translate< 1.5,0,0> }
     cylinder { <0,0,-1.5>,<0,0,1.5>, 0.5 rotate<0,90,0> translate<0, 1.5,0> }
     cylinder { <0,0,-1.5>,<0,0,1.5>, 0.5 rotate<0,90,0> translate<0,-1.5,0> }
  }

object {
    hollow_square 

    texture { T_Stone18 translate <0.1,0.1,0.1> rotate <110, 150*frame_number, 0> scale 3}
    finish { specular 0.5  roughness 0.0025 }
}
