#include <gconf/gconf.h>
#include <gconf/gconf-client.h>
#include <string.h>

#include "appdata.h"
#include "gconf.h"

#define GCONF_PATH "/apps/" APPNAME "/"
#define GCONF_KEY_STATE    GCONF_PATH "state"
#define GCONF_KEY_BOARD    GCONF_PATH "board"
#define GCONF_KEY_SELECTED GCONF_PATH "selected"

void gconf_client_init(appdata_t *appdata) {
  printf("gconf client init()\n");

  /* Get the default client */
  appdata->gconf_client = gconf_client_get_default();
}

void gconf_load(appdata_t *appdata) {
  char *str;
  int state, i, selected;

  printf("gconf load\n");

  /* reset game state (in case load fails) */
  game_restart(appdata->game);
  appdata->game->state = STATE_IDLE;
  appdata->selected->tile = LOC_EMPTY;

  /* read config */
  if((str = gconf_client_get_string(appdata->gconf_client, 
				    GCONF_KEY_BOARD, NULL))) {
    /* this _must_ be a 47 character string */
    if(strlen(str) == 47) {
      state = gconf_client_get_int(appdata->gconf_client, 
				   GCONF_KEY_STATE, NULL);

      selected = gconf_client_get_int(appdata->gconf_client, 
				      GCONF_KEY_SELECTED, NULL);

      printf("board str = %s, state = %d, selected = %d\n", 
	     str, state, selected);

      /* do some sanity checks on the data and use it as game data */
      /* if ok */

      /* copy gconf data into game state machine */
      appdata->game->state = state;
      appdata->selected->tile = selected;
      for(i=0;i<16;i++) {
	int x;
	sscanf(str, "%02x", &x);
	appdata->game->loc[i/4][i%4] = x;
	str += 3;
      }
    }
  }
}

void gconf_save(appdata_t *appdata) {
  char str[64];
  int i;

  printf("gconf save\n");

  /* convert board state into string (47 characters long) */
  str[0] = 0;  // terminate string
  for(i=0;i<16;i++)
    sprintf(str+strlen(str), "%02x%s",
	    0xff & appdata->game->loc[i/4][i%4], (i!=15)?"-":"");

  /* save board state string */
  gconf_client_set_string(appdata->gconf_client, GCONF_KEY_BOARD, str, NULL);

  /* save game state */
  gconf_client_set_int(appdata->gconf_client, GCONF_KEY_STATE, 
		       appdata->game->state, NULL);

  /* save tile in "selected" slot */
  gconf_client_set_int(appdata->gconf_client, GCONF_KEY_SELECTED, 
		       appdata->selected->tile, NULL);
}
