#ifndef GAME_H
#define GAME_H


#include <hildon/hildon-program.h>
#include <hildon/hildon-banner.h>
#include <gtk/gtk.h>


/* game states */
#define STATE_IDLE               0
#define STATE_CPU_SELECTS        1
#define STATE_HUMAN_PLACES       2
#define STATE_HUMAN_SELECTS      3
#define STATE_CPU_PLACES         4

#define LOC_EMPTY  -1

#define ____  LOC_EMPTY
#define abcd  0
#define abcD  1
#define abCd  2
#define abCD  3
#define aBcd  4
#define aBcD  5
#define aBCd  6
#define aBCD  7
#define Abcd  8
#define AbcD  9
#define AbCd 10
#define AbCD 11
#define ABcd 12
#define ABcD 13
#define ABCd 14
#define ABCD 15

typedef unsigned short stack_state_t;

typedef struct {
  signed char loc[4][4];
  stack_state_t stack;
  int state;

  /* stuff to handle ai in seperate process */
  GThread *thread;
  HildonWindow *window;  
  GtkWidget *animation;
  int async_result, tile;
} game_state_t;

extern void game_init(game_state_t *game);
extern int game_get_tile_at(game_state_t *game, int x, int y);
extern gboolean game_tile_on_stack(game_state_t *game, int tile);
extern void game_place_tile(game_state_t *game, int tile, int x, int y);
extern void game_stack_remove(game_state_t *game, int tile);

#define GAME_RUN  0
#define GAME_WON  1
#define GAME_DRAW 2

/* routines to actually run the ai */
extern void game_give(game_state_t *game);
extern void game_place(game_state_t *game, int tile);
extern int game_check(game_state_t *game);
extern void game_restart(game_state_t *game);

#endif // GAME_H
