using GLib;
using Gtk;

public class Common
{
	private Gtk.Image item_background;
	private Gtk.Image default_item;
	private HashTable<string,Gtk.Image> image_cache;
	private Gdk.Pixbuf default_icon;
	
	public Common()
	{
		image_cache = new HashTable<string, Gtk.Image>(str_hash, str_equal);
		item_background = new Gtk.Image.from_file("/usr/share/knots/knotsitem.png");
		default_item = new Gtk.Image.from_file("/usr/share/knots/knots_dir.png");
		Gtk.IconTheme icon_theme = Gtk.IconTheme.get_default();
		default_icon = icon_theme.load_icon("knots2", 64, Gtk.IconLookupFlags.USE_BUILTIN);
		if (default_icon != null)
		{
			if (default_icon.get_width() != 64 || default_icon.get_height() != 54)
			{
				default_icon = default_icon.scale_simple(64, 54, Gdk.InterpType.BILINEAR);
			}
		}
	}
	
	public void cache_image(string mid, Gtk.Image image)
	{
		// Add proper deleting, this is just stupid
		if (image_cache.size() > 40)
			image_cache.steal_all();
		image_cache.insert(mid, image);
	}
	
	public Gtk.Image? cached_image(string mid)
	{
		return (Gtk.Image)image_cache.lookup(mid);
	}
	
	public Gtk.Image get_item_background_image()
	{
		return new Gtk.Image.from_pixbuf(item_background.get_pixbuf());
	}
	
	public Gtk.Image get_default_item_image()
	{
		return new Gtk.Image.from_pixbuf(default_item.get_pixbuf());
	}
	
	public Gdk.Pixbuf get_app_icon()
	{
		return default_icon;
	}
	
	public bool string_array_contains(string[] s, string ss)
	{
		foreach (string token in s)
		{
			if (token == ss)
				return true;
		}
		return false;
	}
}
