using GLib;
using Gtk;
using Pango;

public class Item : Gtk.Fixed
{
	Knots knots;
	HashTable fields;
	Gtk.Label label;
	string text;
	int item_type;
	public static int CATEGORY = 0;
	public static int TAG = 1;
	public static int VALUE = 2;
	public static int ITEM = 3;
	public static int DIR = 4;
	public static int VIRTUAL = 5;
	public static int SERVER = 6;
	public static int BUTTON = 7;
	EventBox eb;
	Gtk.Image background;
	Gtk.Image image;
	Gdk.Pixbuf default_image;
	private bool icon_view;
	private bool grabbing;
	
	public Item(Knots knots, HashTable fields, bool icon_view) {
		this.knots = knots;
		this.fields = fields;
		this.icon_view = icon_view;
		this.grabbing = false;
		init_widget();
	}
	
	public bool has_icon_view()
	{
		return this.icon_view;
	}
	
	public void init_widget()
	{
		string[] types = {"category", "tag", "value", "name", "dirname", "virtual", "server", "button"};
		for (int i = 0; i < types.length; i++)
		{
			if (fields.lookup(types[types.length - 1 - i]) != null)
			{
				text = (string)fields.lookup(types[types.length - 1 - i]);
				item_type = types.length - 1 - i;
				break;
			}
		}
		if (icon_view)
		{
			image = new Gtk.Image();
			load_image();
		}
	}
	
	public void create()
	{
		this.width_request = width();
		this.height_request = height();
		if (icon_view)
		{
			if (text.len() > 25)
				text = text.substring(0, 25);
			background = knots.get_common().get_item_background_image();
			background.width_request = width();
			background.height_request = height();
			this.put(background, 0, 0);
			eb = new EventBox();
			eb.width_request = 160;
			eb.height_request = 130;
			knots.change_background_color(eb, "#000000");
			this.put(eb, 10, 15);
			label = new Label(get_item_label());
			knots.change_foreground_color(label, "#eeeeee");
			label.set_justify(Gtk.Justification.CENTER);
			label.height_request = 15;
			label.width_request = 160;
			this.put(label, 10, 150);
			Pango.FontDescription f = label.get_pango_context().get_font_description();
			f.set_size(1024 * 10);
			label.modify_font(f);
			knots.change_background_color(this, "#000000");
			image.width_request = 160;
			image.height_request = 125;
			eb.add(image);
			knots.change_background_color(this, "#000000");
		}
		else
		{
			eb = new EventBox();
			eb.width_request = width();
			eb.height_request = height();
			knots.change_background_color(eb, "#111111");
			this.put(eb, 0, 0);
			label = new Label(get_item_label());
			label.set_justify(Gtk.Justification.LEFT);
			knots.change_foreground_color(label, "#eeeeee");
			eb.add(label);
			image = new Gtk.Image();
			knots.change_background_color(this, "#111111");
			
		}
	}
	
	public void new_width(int width)
	{
		var children = get_children();
		foreach (Gtk.Widget child in children)
		{
			child.width_request = width;
		}
		this.width_request = width;
	}
	
	
	public string get_item_attribute(string key)
	{
		return (string)fields.lookup(key);
	}
	
	public int get_item_type()
	{
		return item_type;
	}
	
	public string get_item_label()
	{
		return text;
	}
	
	public int get_item_id()
	{
		return get_item_attribute("id").to_int();
	}
	
	public string get_plot()
	{
		return get_item_attribute("info");
	}
	
	public Gtk.Image get_image()
	{
		return image;
	}
	
	public bool item_selected(Gdk.EventButton? eb, long press_seconds)
	{
		if (!knots.get_browser().search_active())
		{
			if (get_item_type() == BUTTON)
			{
				highlight();
				this.queue_draw();
				if (get_item_id() == 1)
					knots.connect_server_automatically();
				else
				if (get_item_id() == 2)
					knots.connect_server_manually();
			}
			else
			if (get_item_type() == SERVER)
			{
				highlight();
				this.queue_draw();
				knots.get_connection().select_server(get_item_id());
				knots.connect_server();
			}
			else
			if (get_item_type() == DIR)
			{
				highlight();
				this.queue_draw();
				knots.get_browser().browse_by_path(get_item_attribute("dir"), false);
			}
			else
			if (get_item_type() == VIRTUAL)
			{
				highlight();
				this.queue_draw();
				knots.get_browser().show_virtual_category(get_item_attribute("search"), 1);
			}
			else
			if (get_item_type() != ITEM)
			{
				highlight();
				knots.get_browser().browsepaths[get_item_type()] = get_item_id();
				knots.get_browser().pages[get_item_type()] = 1;
				this.queue_draw();
				knots.get_browser().browse();
			}
			else
			{
				knots.get_info().show_info(this);
			}
		}
		return false;
	}
	
	public bool refetch_screenshot()
	{
		if (!grabbing && this.icon_view)
		{
			grabbing = true;
			try
			{
				Thread.create(refetch_new_screenshot, true);
			}
			catch (ThreadError e)
			{
			}
		}
		return false;
	}
	
	public void* refetch_new_screenshot()
	{
		if (get_item_attribute("mid") != null)
			knots.get_common().clear_image(get_item_attribute("mid"));
		knots.get_connection().set_url_cache(false);
		string? mid = knots.get_connection().fetch("/external/refetch_screenshot?id=" + get_item_id().to_string());
		if (mid != null && mid != "")
		{
			fields.insert("mid", mid.strip());
			GLib.Idle.add(load_image);
			knots.get_common().clear_cache(1);
		}
		grabbing = false;
		return null;
	}
	
	public void highlight()
	{
		knots.change_foreground_color(label, "#FB8F00");
	}
	
	public void lowlight()
	{
		knots.change_foreground_color(label, "#ffffff");
	}
	
	public bool load_image()
	{
		if (this.icon_view && get_item_attribute("mid") != null && get_item_attribute("mid") != "")
		{
			Gtk.Image img = knots.get_common().cached_image(get_item_attribute("mid"));
			if (img == null)
			{
				knots.debug("No cached image for %s, loading from server\n", get_item_attribute("mid"));
				var session = new Soup.SessionSync ();
				string auth = "";
				if (knots.get_connection().username() != null && knots.get_connection().password() != null)
					auth = knots.get_connection().username() + ":" + knots.get_connection().password() + "@";
				var message = new Soup.Message ("GET", (knots.get_connection().uses_ssl() ? "https" : "http") + "://" + auth + knots.get_connection().address() + "/root/resource_file?type=screenshot&mid=" + get_item_attribute("mid") + "&mediatype=0");
				message.got_body += (message) => {
					try
					{
						var filename = "/tmp/knots" + get_item_id().to_string();
						FileUtils.set_contents (filename, message.response.body, message.response.length);
						Gtk.Image img2 = new Gtk.Image.from_file(filename);
						image.set_from_pixbuf(img2.get_pixbuf());
						default_image = img2.get_pixbuf();
						FileUtils.unlink(filename);
						knots.get_common().cache_image(get_item_attribute("mid"), img2);
						knots.debug("Image %s cached\n", get_item_attribute("mid"));
					}
					catch (GLib.Error e)
					{
						use_default_images();
					}
				};
				session.send_message (message);
			}
			else
			{
				knots.debug("Using cached image for %s\n", get_item_attribute("mid"));
				image.set_from_pixbuf(img.get_pixbuf());
				default_image = img.get_pixbuf();
			}
		}
		else
		{
			use_default_images();
		}
		if (knots.visible_page(knots.get_info()))
			knots.get_info().load_image();
		return false;
	}
	
	public Gdk.Pixbuf get_default_image()
	{
		return default_image;
	}
	
	public void use_default_images()
	{
		if (get_item_type() == ITEM)
		{
			if (get_item_attribute("mediatype") == null || get_item_attribute("mediatype").to_int() != 1)
				default_image = knots.get_common().get_default_video_item_image().get_pixbuf();
			else
				default_image = knots.get_common().get_default_music_item_image().get_pixbuf();
		}
		else
		if (get_item_type() == BUTTON)
			default_image = knots.get_common().get_default_connect_item_image().get_pixbuf();
		else
		if (get_item_type() == SERVER)
			default_image = knots.get_common().get_default_server_item_image().get_pixbuf();
		else
			default_image = knots.get_common().get_default_dir_image().get_pixbuf();
		if (icon_view)
			image.set_from_pixbuf(default_image);
		else
			image.set_from_pixbuf(default_image.scale_simple(64, 64, Gdk.InterpType.BILINEAR));
	}
	
	public int width()
	{
		return icon_view ? 180 : knots.get_window().allocation.width;
		
	}
	
	public int height()
	{
		return icon_view ? 180 : 50;
	}
}
