using GLib;
using Gtk;
using Hildon;
using Gdk;

public class Info : PageWidget
{
	Gtk.Image image;
	Label plot;
	Gtk.ToolButton clear_position_button;
	int id;
	private Item item;
	/* Declare global and private to workaround a vala bug */
	private int[] tagids;
	private int[] valueids;
	private string[] tag_values;
	private string[] value_values;
	
	public override void add_signals()
	{
		get_toolbar_button(0).clicked += () => {
			this.hide_info();
		};
		get_toolbar_button(1).clicked += () => {
			this.get_knots().get_player().play(this.id.to_string(), this.get_knots().get_player().ITEM);
		};
		get_toolbar_button(2).clicked += () => {
			this.get_knots().get_player().play(this.id.to_string(), this.get_knots().get_player().ARTIST);
		};
		get_toolbar_button(3).clicked += () => {
			this.get_knots().get_player().play(this.id.to_string(), this.get_knots().get_player().ALBUM);
		};
		get_toolbar_button(4).clicked += () => {
			this.get_knots().get_playlist().add_to_playlist(this.id);
			if (get_knots().get_playlist().playlist_contains_item(this.id))
			{
				get_toolbar_button(4).hide();
				get_toolbar_button(5).show();
			}
		};
		get_toolbar_button(5).clicked += () => {
			
			if (item.get_item_attribute("pid") == null)
				this.get_knots().get_playlist().remove_item_from_playlist(this.id);
			else
				this.get_knots().get_playlist().remove_from_playlist(((string)item.get_item_attribute("pid")).to_int());
			
			if (item.get_item_attribute("pid") != null || !get_knots().get_playlist().playlist_contains_item(this.id))
			{
				get_toolbar_button(4).show();
				get_toolbar_button(5).hide();
				if (item.get_item_attribute("pid") != null)
					hide_info();
			}
		};
	}
	
	public override Gtk.Widget create_content()
	{
		clear_position_button = new Gtk.ToolButton(new Gtk.Image.from_file("/usr/share/knots/knots_button_clear_position.png"), "");
		clear_position_button.clicked += () => {
			clear_position();
		};
		image = new Gtk.Image();
		EventBox eb2 = new EventBox();
		get_knots().change_background_color(eb2, "#000000");
		eb2.button_release_event += regrab_image;
		eb2.add(image);
		plot = new Gtk.Label("Plot");
		plot.set_line_wrap(true);
		get_knots().change_foreground_color(plot, "#fff");
		Gtk.VBox f = new Gtk.VBox(false, 10);
		Gtk.HBox h = new Gtk.HBox(true, 10);
		h.pack_start(eb2, false, false, 10);
		h.pack_start(clear_position_button, false, false, 10);
		f.pack_start(h, false, false, 10);
		f.pack_start(plot, false, false, 10);
		Scroller scroller = new Scroller(f);
		scroller.set_scroll_policy(false, true);
		return scroller;
	}
	
	public override string[] get_toolbar_items()
	{
		return {"back", "play", "play_artist", "play_album", "add_to_playlist", "remove_from_playlist"};
	}
	
	public void show_info(Item? item)
	{
		if (item != null)
			this.item = item;
		get_knots().get_info().reveal();
		this.id = this.item.get_item_id();
		if (get_knots().get_playlist().playlist_contains_item(id))
		{
			get_toolbar_button(4).hide();
			get_toolbar_button(5).show();
		}
		else
		{
			get_toolbar_button(4).show();
			get_toolbar_button(5).hide();
			get_toolbar_button(4).set_sensitive(get_knots().get_playlist().can_add_to_playlist(this.item.get_item_attribute("mediatype").to_int()));
			
		}
		if (this.item.get_item_attribute("mediatype").to_int() != 1)
		{
			get_toolbar_button(2).set_sensitive(false);
			get_toolbar_button(3).set_sensitive(false);
		}
		else
		{
			get_toolbar_button(2).set_sensitive(true);
			get_toolbar_button(3).set_sensitive(true);
		}
		image.set_from_pixbuf(this.item.get_image().get_pixbuf());
		update_info();
	}
	
	public int item_id()
	{
		return this.id;
	}
	
	public bool regrab_image(Gdk.EventButton eb)
	{
		if (!((Scroller)get_content()).window_scrolled())
		{
			if (item != null)
			{
				get_knots().alert("Grabbing new image");
				item.refetch_screenshot();
			}
		}
		return false;
	}
	
	public void load_image()
	{
		if (this.item != null)
		{
			image.set_from_pixbuf(this.item.get_default_image());
		}
	}
	
	public void fetch_subtitles()
	{
		if (this.item != null && this.item.get_item_attribute("mediatype").to_int() != 1 && get_knots().visible_page(this))
		{
			string[] ids = new string[0];
			string[] exts = new string[0];
			get_knots().get_connection().set_url_cache(false);
			XMList list = new XMList(get_knots().get_connection().fetch("/external/subtitles?id=" + this.id.to_string()));
			if (list.itemcount() > 0)
			{
				MessageDialog dialog = new MessageDialog.with_markup(null, 0, Gtk.MessageType.QUESTION, Gtk.ButtonsType.OK_CANCEL, "Fetch subtitles for " + item.get_item_label());
				dialog.set_image(new Gtk.Image.from_pixbuf(item.get_default_image()));
				ComboBox cb = new ComboBox.text();
				foreach(HashTable<string,string> ht in list.items())
				{
					cb.append_text((string)ht.lookup("name"));
					ids += (string)ht.lookup("id");
					exts += (string)ht.lookup("ext");
				}
				dialog.vbox.add(cb);
				cb.show();
				cb.set_active(0);
				var res = dialog.run ();
				if (res == ResponseType.OK)
				{
					int sel = cb.get_active();
					if (sel != -1)
					{
						get_knots().get_connection().set_url_cache(false);
						string resp = get_knots().get_connection().fetch("/external/download_sub?id=" + this.id.to_string() + "&subid=" + ids[sel] + "&ext=" + exts[sel]);
						if (resp != null && resp.str("OK") != null)
							get_knots().alert("Download successful");
						else
							get_knots().alert("Download failed");
					}
						
				}
				dialog.destroy ();
			}
			else
			{
				get_knots().alert("No subtitles found");
			}
		}
	}
	
	public void tag_item()
	{
		if (get_knots().visible_page(this) || get_knots().visible_page(get_knots().get_browser()))
		{
			bool active = true;
			bool was_tagged = false;
			string tagged = get_knots().visible_page(this) ? item_id().to_string() : get_knots().get_browser().get_item_ids(null);
			if (tagged != "")
			{
				get_knots().get_connection().set_url_cache(false);
				XMList list = new XMList(get_knots().get_connection().fetch("/external/all_tags"));
				tagids = {};
				tag_values = {};
				valueids = {};
				value_values = {};
				MessageDialog dialog = new MessageDialog.with_markup(null, 0, Gtk.MessageType.QUESTION, Gtk.ButtonsType.CLOSE, "Tag " + (get_knots().visible_page(this) ? item.get_item_attribute("name") : " item(s)"));
				ComboBox tags = new ComboBox.text();
				ComboBox values = new ComboBox.text();
				Gtk.Entry tag_text = new Gtk.Entry();
				Gtk.Entry value_text = new Gtk.Entry();
				Gtk.Button tag_item = new Gtk.Button.with_label("Tag");
				tag_item.clicked += () => {
					if (tag_items_with(tagged, tag_text.get_text(), value_text.get_text()))
						was_tagged = true;
				};
				dialog.vbox.pack_start(tags, false, true, 1);
				dialog.vbox.pack_start(values, false, true, 1);
				dialog.vbox.pack_start(tag_text, false, true, 1);
				dialog.vbox.pack_start(value_text, false, true, 1);
				dialog.vbox.pack_start(tag_item, false, true, 1);
				dialog.vbox.show_all();
				foreach(HashTable<string,string> ht in list.items())
				{
					tags.append_text((string)ht.lookup("tag"));
					tagids += ((string)ht.lookup("id")).to_int();
					tag_values += (string)ht.lookup("tag");
				}
				tags.changed += () => {
					if (active && tags.get_active() != -1)
					{
						values.set_active(0);
						while (values.get_active() != -1)
						{
							values.remove_text(0);
							values.set_active(0);
						}
						int id = tagids[tags.get_active()];
						XMList list2 = new XMList(get_knots().get_connection().fetch("/external/all_values_for_tag?id=" + id.to_string()));
						if (list2.itemcount() > 0)
						{
							int index = 0;
							foreach(HashTable<string,string> ht2 in list2.items())
							{
								values.append_text((string)ht2.lookup("value"));
								valueids += ((string)ht2.lookup("id")).to_int();
								if (index < value_values.length)
									value_values[index] = (string)ht2.lookup("value");
								else
									value_values += (string)ht2.lookup("value");
								index += 1;
							}
						}
						else
						{
							get_knots().alert("No values for this tag");
							
						}
						
						if (tags.get_active() != -1)
							tag_text.set_text(tag_values[tags.get_active()]);
						value_text.set_text("");
					}
				};
				values.changed += () => {
					if (values.get_active() != -1)
						value_text.set_text(value_values[values.get_active()]);
				};
				dialog.run();
				active = false;
				dialog.destroy();
				if (get_knots().visible_page(this) && was_tagged)
					update_info();
			}
		}
	}
	
	public void update_info()
	{
		if (this.item != null)
		{
			item.load_image();
			image.set_from_pixbuf(item.get_image().get_pixbuf());
		}
		plot.set_label("");
		get_knots().get_connection().set_url_cache(false);
		string info = get_knots().get_connection().fetch("/external/info?id=" + this.id.to_string());
		if(info != null && info.str("Resume position") != null)
			clear_position_button.show();
		else
			clear_position_button.hide();
		plot.set_markup(info);
		((Scroller)get_content()).scroll_to_top();
	}
	
	public bool tag_items_with(string items, string tag, string value)
	{
		if (tag != null && tag.length > 0 && value != null && value.length > 0)
		{
			string data = get_knots().get_connection().fetch("/external/tag_item?id=" + items + "&tag=" + Soup.Uri.encode(tag, "") + "&value=" + Soup.Uri.encode(value, ""));
			if (data != null && data.str("OK") != null)
			{
				if (data.str("OK_ALBUM") == null)
					get_knots().alert("Tagging successful");
				else
				{
					get_knots().alert("Tagging successful. Album art applied to all tagged items.");
					get_knots().get_common().clear_cache(1);	
				}
				return true;
			}
			else
			{
				get_knots().alert("Tagging failed");
			}
		}
		else
			get_knots().alert("Please fill both tag and value");
		return false;
	}
	
	public void clear_position()
	{
		get_knots().get_connection().set_url_cache(false);
		get_knots().get_connection().fetch("/external/clear_position?id=" + this.id.to_string());
		update_info();
	}
	
	public string humanize_duration(int duration)
	{
		return timefy(duration / 60 / 60 % 60) + ":" + timefy(duration / 60 % 60) + ":" + timefy(duration % 60);
	}
	
	public string timefy(int val)
	{
		if (val < 10)
			return "0" + val.to_string();
		else
			return val.to_string();
	}
	
	public void hide_info()
	{
		if (item.get_item_attribute("pid") == null)
			this.get_knots().get_browser().reveal();
		else
			this.get_knots().get_playlist().reveal();
	}
}
