using GLib;
using Gtk;

public class Common
{
	private Gtk.Image item_background;
	private Gtk.Image default_music_item;
	private Gtk.Image default_video_item;
	private Gtk.Image default_connect_item;
	private Gtk.Image default_server_item;
	private Gtk.Image default_dir;
	private HashTable<string,Gtk.Image> image_cache;
	private HashTable<string,string> url_cache;
	private Gdk.Pixbuf default_icon;
	private int cached_images;
	private Knots knots;
	
	public Common(Knots knots)
	{
		this.knots = knots;
		cached_images = knots.get_settings().get_value_default_to("cached_images", "100").to_int();
		image_cache = new HashTable<string, Gtk.Image>(str_hash, str_equal);
		url_cache = new HashTable<string, string>(str_hash, str_equal);
		item_background = new Gtk.Image.from_file("/usr/share/knots/knotsitem.png");
		default_dir = new Gtk.Image.from_file("/usr/share/knots/knots_dir.png");
		default_music_item = new Gtk.Image.from_file("/usr/share/knots/knots_item_music.png");
		default_video_item = new Gtk.Image.from_file("/usr/share/knots/knots_item_video.png");
		default_connect_item = new Gtk.Image.from_file("/usr/share/knots/knots_item_connect.png");
		default_server_item = new Gtk.Image.from_file("/usr/share/knots/knots_item_server.png");
		Gtk.IconTheme icon_theme = Gtk.IconTheme.get_default();
		try
		{
			default_icon = icon_theme.load_icon("knots2", 64, Gtk.IconLookupFlags.USE_BUILTIN);
		}
		catch (GLib.Error e)
		{
			print("%s\n", e.message);
		}
		if (default_icon != null)
		{
			if (default_icon.get_width() != 64 || default_icon.get_height() != 54)
			{
				default_icon = default_icon.scale_simple(64, 54, Gdk.InterpType.BILINEAR);
			}
		}
	}
	
	public void clear_cache(int type)
	{
		if (type == 0 || type == 2)
			image_cache.remove_all();
		if (type == 1 || type == 2)
			url_cache.remove_all();
		knots.debug("Clearing cache type %s\n", type.to_string());
	}
	
	public void clear_url(string url)
	{
		url_cache.remove(url);
		knots.debug("Removing url %s\n", url);
	}
	
	public void clear_image(string id)
	{
		image_cache.remove(id);
		knots.debug("Removing image %s\n", id);
	}
	
	public void cache_image(string mid, Gtk.Image image)
	{
		image_cache.insert(mid, image);
	}
	
	public void cache_url(string url, string content)
	{
		url_cache.insert(url, content);
	}
	
	public string cached_url(string url)
	{
		return (string)url_cache.lookup(url);
	}
	
	public Gtk.Image? cached_image(string mid)
	{
		return (Gtk.Image)image_cache.lookup(mid);
	}
	
	public Gtk.Image get_default_connect_item_image()
	{
		return new Gtk.Image.from_pixbuf(default_connect_item.get_pixbuf());
	}
	
	public Gtk.Image get_default_server_item_image()
	{
		return new Gtk.Image.from_pixbuf(default_server_item.get_pixbuf());
	}
	
	public Gtk.Image get_default_music_item_image()
	{
		return new Gtk.Image.from_pixbuf(default_music_item.get_pixbuf());
	}
	
	public Gtk.Image get_default_video_item_image()
	{
		return new Gtk.Image.from_pixbuf(default_video_item.get_pixbuf());
	}
	
	public Gtk.Image get_default_dir_image()
	{
		return new Gtk.Image.from_pixbuf(default_dir.get_pixbuf());
	}
	
	public Gdk.Pixbuf get_app_icon()
	{
		return default_icon;
	}
	
	public Gtk.Image get_item_background_image()
	{
		return new Gtk.Image.from_pixbuf(item_background.get_pixbuf());
	}
	
	public bool string_array_contains(string[] s, string ss)
	{
		foreach (string token in s)
		{
			if (token == ss)
				return true;
		}
		return false;
	}
}
