using Gtk;
using Osso;

public class PageWidget : Gtk.VBox
{
	private Knots knots;
	private Gtk.Widget content;
	private Gtk.HBox toolbar;
	private GLib.TimeVal clicktime;
	private int press_time;
	
	public virtual void init(Knots knots)
	{
		this.clicktime = TimeVal();
		this.knots = knots;
		this.toolbar = create_toolbar();
		this.content = create_content();
		this.add_signals();
		pack_start(content, true, true, 0);
		pack_start(toolbar, false, false, 0);
		knots.change_background_color(toolbar, "#555555");
	}
	
	public Gtk.HBox create_toolbar()
	{
		Gtk.HBox toolbar = new Gtk.HBox(false, 0);
		toolbar.height_request = 70;
		foreach(string item in get_toolbar_items())
		{
			Gtk.ToolButton toolbutton = new Gtk.ToolButton(new Gtk.Image.from_file("/usr/share/knots/knots_button_" + item + ".png"), "");
			toolbar.pack_start(toolbutton, true, false, 0);
		}
		return toolbar;
	}
	
	public int get_sec_pressed()
	{
		return press_time;
	}
	
	public virtual void display_state_changed(Osso.DisplayState state)
	{
	
	}
	
	public virtual void window_state_changed(bool covered)
	{
	
	}
	
	public virtual void scroll_up()
	{
	
	}
	
	public virtual void scroll_down()
	{
	
	}
	
	public Gtk.ToolButton get_toolbar_button(int index)
	{
		return ((Gtk.ToolButton)get_toolbar().get_children().nth_data(index));
	}
	
	public virtual void orientation_change()
	{
		if (toolbar != null)
		{
			if (get_knots().ORIENTATION == get_knots().LANDSCAPE)
			{
				reorder_child(toolbar, 1);
			}
			else
			{
				reorder_child(toolbar, 0);
			}
		}
	}
	
	public virtual Gtk.Widget create_content()
	{
		return new Gtk.HBox(false, 0);
	}
	
	public Gtk.Widget get_content()
	{
		return content;
	}
	
	public virtual void add_signals()
	{
	}
	
	public virtual string[] get_toolbar_items()
	{
		return {"back"};
	}
	
	public Knots get_knots()
	{
		return knots;
	}
	
	public Gtk.HBox get_toolbar()
	{
		return toolbar;
	}
	
	public virtual void reveal()
	{
		get_knots().get_notebook().set_current_page(get_knots().get_notebook().page_num(this));
	}
}
