#include <stdio.h>
#include <stdlib.h>
#include <X11/Xlib.h>
#include <X11/extensions/Xrandr.h>

static char *keyname[4] = { "Up", "Right", "Down", "Left" };
static KeyCode keycode[4] = { 111, 114, 116, 113 };

static int
check_init_rotation ()
{
  int enabled;
  Display *dpy;
  int xrr_event_base, xrr_error_base;
  int xrr_major, xrr_minor;
  dpy = XOpenDisplay (NULL);
  if (dpy == NULL)
    {
      enabled = 0;
    }

  if (XRRQueryExtension (dpy, &xrr_event_base, &xrr_error_base) == False
      || XRRQueryVersion (dpy, &xrr_major, &xrr_minor) == 0 || xrr_major != 1 || xrr_minor < 1)
    enabled = 0;
  else
    enabled = 1;

  XCloseDisplay (dpy);
  return enabled;
}


static int
get_rotation ()
{
  int rotation;
  XRRScreenConfiguration *rr_screen;
  Rotation current_rotation;
  Display *dpy;
  int screen;

  if (check_init_rotation () == 0)
    return -1;

  dpy = XOpenDisplay (NULL);
  screen = DefaultScreen (dpy);

  rr_screen = XRRGetScreenInfo (dpy, RootWindow (dpy, screen));
  XRRRotations (dpy, screen, &current_rotation);

  XRRFreeScreenConfigInfo (rr_screen);

  switch (current_rotation)
    {
    case RR_Rotate_270:
      rotation = 3;
      break;
    case RR_Rotate_180:
      rotation = 2;
      break;
    case RR_Rotate_90:
      rotation = 1;
      break;
    case RR_Rotate_0:
      rotation = 0;
      break;
    default:
      fprintf (stderr, "Unknown RANDR rotation: %d\n", current_rotation);
      rotation = 0;
      break;
    }

  XCloseDisplay (dpy);

  return rotation;
}


static void
set_rotation (int rotation)
{

  Rotation sc_rotation;
  XRRScreenConfiguration *scr_config;
  Rotation current_rotation;
  int size;
  int i;
  Display *dpy;
  int screen;


  if (check_init_rotation () == 0)
    return;

  dpy = XOpenDisplay (NULL);
  screen = DefaultScreen (dpy);

  scr_config = XRRGetScreenInfo (dpy, RootWindow (dpy, screen));
  size = XRRConfigCurrentConfiguration (scr_config, &current_rotation);

  switch (rotation)
    {
    case 3:
      sc_rotation = RR_Rotate_270;
      break;
    case 2:
      sc_rotation = RR_Rotate_180;
      break;
    case 1:
      sc_rotation = RR_Rotate_90;
      break;
    case 0:
      sc_rotation = RR_Rotate_0;
      break;
    default:
      fprintf (stderr, "Unknown RANDR rotation: %d\n", rotation);
      sc_rotation = RR_Rotate_0;
      break;
    }

  /* Rotate d-pad */
  for (i = 0; i < 4; i++)
    {
      KeySym keysym = XStringToKeysym (keyname[(rotation + i) % 4]);
      XChangeKeyboardMapping (dpy, keycode[i], 1, &keysym, 1);
    }

  XRRSetScreenConfig (dpy, scr_config, RootWindow (dpy, screen), size, sc_rotation, CurrentTime);
  XRRFreeScreenConfigInfo (scr_config);
  XCloseDisplay (dpy);
}

int main(int argc, char *argv[])
{
	if (argc == 1)
		printf("%i", get_rotation());
	else
	if (argc == 2)
	{
		int r = atoi(argv[1]);
		if (r >= 0 && r < 4)
		{
			set_rotation(r);	
		}
	}
	return 0;
}
