using Hildon;

public class Progress : GLib.Object
{
	Gtk.Widget banner;
	int amount;
	int count;
	
	public Progress(Knots knots)
	{
		banner = Hildon.Banner.show_progress(knots.get_window(), null, "");
		banner.hide();
	}
	
	public void init(string message, int amount)
	{
		((Hildon.Banner)banner).set_text(message);
		((Hildon.Banner)banner).set_fraction(0);
		this.amount = amount;
		if (amount < 0)
			amount = 1;
		count = 0;
		banner.show();
	}
	
	public void update()
	{
		this.count += 1;
		((Hildon.Banner)banner).set_fraction(((double)count / (double)amount));
		if (count >= amount)
			banner.hide();
	}
}
