/**
  This file belong to the KMPlayer project, a movie player plugin for Konqueror
  Copyright (C) 2007  Koos Vriezen <koos.vriezen@gmail.com>

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**/

#ifndef KMPLAYER_VIEW_AREA_H
#define KMPLAYER_VIEW_AREA_H

#include <gtk/gtkwidget.h>

#include "kmplayertypes.h"
#include "surface.h"

typedef struct _Application Application;

namespace KMPlayer {

class View;
class ViewAreaPrivate;
class RepaintUpdater;

/*
 * The area in which the video widget and controlpanel are laid out
 */
class KMPLAYER_EXPORT ViewArea {
public:
    ViewArea ();
    ~ViewArea ();
    void reset ();
    KDE_NO_EXPORT bool isFullScreen () const { return m_fullscreen; }
    Surface *getSurface (Mrl *mrl);
    void setAudioVideoGeometry (const IRect &rect, unsigned int * bg);
    void setAudioVideoNode (NodePtr n);
    void setEventFiltering (Application *app, bool on);
    void scheduleRepaint (const IRect &rect);
    void addUpdater (Node *node);
    void removeUpdater (Node *node);
    void resizeEvent ();
    void deleteEvent ();
    void enableUpdaters (bool enable, unsigned int off_time);
    void scale (int);
    void setAspect (float a);
    void mousePressEvent (int x, int y);
    void mouseDoubleClickEvent ();
    void paintEvent (const IRect &);
    bool timeoutPaintEvent ();
    void controlsVisible (Application *app, bool show);
    void prepareFullscreenToggle ();
    void enableVideoInputFilter (bool enable);
    KDE_NO_EXPORT IRect videoGeometry () const { return m_av_geometry; }
    int width () const;
    int height () const;
    GtkWidget *viewWidget () const { return widget; }
    GdkWindow *videoWindow () const { return video; }
    GdkWindow *videoInputWindow () const { return video_input; }
    Mrl *videoMrl () { return video_node ? video_node->mrl () : NULL; }
    void setOutputWidget (Application *, GtkWidget * w);
    void setControlsOverlap (bool b) { m_controls_overlap = b; }
    GdkWindow *controls;
    int controls_timer;
private:
    void syncVisual (const IRect & rect);
    void updateSurfaceBounds ();
    bool scheduleRepaintTimeout (unsigned int cur_time);
    ViewAreaPrivate *d;
    RepaintUpdater *m_updaters;
    IRect m_av_geometry;
    float aspect;
    IRect m_repaint_rect;
    GtkWidget *widget;
    GdkWindow *video;
    GdkWindow *video_input;
    SurfacePtr surface;
    NodePtrW video_node;
    unsigned int last_repaint_time;
    unsigned int next_repaint_time;
    unsigned int penalty;
    int cur_timeout;
    int m_repaint_timer;
    bool m_fullscreen;
    bool m_event_filter_on;
    bool m_updaters_enabled;
    bool m_controls_overlap;
    bool m_video_filter;
};

} // namespace KMPlayer

#endif
