/**
 * Copyright (C) 2005 by Koos Vriezen <koos ! vriezen ? gmail ! com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License version 2 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 **/

//#include <config.h>
#include <string.h>
#include "kmplayer_rss.h"

using namespace KMPlayer;

KMPLAYER_NO_EXPORT Node *RSS::Rss::childFromTag (const String & tag) {
    if (!strcmp ((const char *) tag, "channel"))
        return new RSS::Channel (m_doc);
    return NULL;
}

KMPLAYER_NO_EXPORT Node *RSS::Channel::childFromTag (const String & tag) {
    const char *ctag = (const char *) tag;
    if (!strcmp (ctag, "item"))
        return new RSS::Item (m_doc);
    else if (!strcmp (ctag, "title"))
        return new DarkNode (m_doc, tag, id_node_title);
    else if (!strncmp (ctag, "itunes", 6) ||
            !strncmp (ctag, "media", 5))
        return new DarkNode (m_doc, tag, id_node_ignored);
    return NULL;
}

KMPLAYER_NO_EXPORT void RSS::Channel::closed () {
    for (Node *c = firstChild (); c; c = c->nextSibling ())
        if (c->id == id_node_title) {
            title = c->innerText ().stripWhiteSpace ();
            break;
        }
    Title::closed ();
}

KMPLAYER_NO_EXPORT bool RSS::Channel::expose () const {
    return !title.isEmpty () || //return false if no caption and only one
        previousSibling () || nextSibling ();
}

KMPLAYER_NO_EXPORT Node *RSS::Item::childFromTag (const String & tag) {
    const char *ctag = (const char *) tag;
    if (!strcmp (ctag, "enclosure"))
        return new RSS::Enclosure (m_doc);
    else if (!strcmp (ctag, "title"))
        return new DarkNode (m_doc, tag, id_node_title);
    else if (!strcmp (ctag, "description"))
        return new DarkNode (m_doc, tag, id_node_description);
    else if (!strcmp (ctag, "category"))
        return new DarkNode (m_doc, tag, id_node_category);
    else if (!strncmp (ctag, "itunes", 6) ||
            !strncmp (ctag, "feedburner", 10) ||
            !strncmp (ctag, "media", 5))
        return new DarkNode (m_doc, tag, id_node_ignored);
    return NULL;
}

KMPLAYER_NO_EXPORT void RSS::Item::closed () {
    cached_play_type = play_type_none;
    for (Node *c = firstChild (); c; c = c->nextSibling ()) {
        switch (c->id) {
            case id_node_title:
                title = c->innerText ().stripWhiteSpace ();
                break;
            case id_node_enclosure:
                enclosure = c;
                src = c->mrl ()->src;
                break;
            case id_node_description:
                cached_play_type = play_type_info;
                break;
        }
    }
    if (enclosure && !enclosure->mrl ()->src.isEmpty ()) {
        cached_play_type = play_type_audio;
        enclosure->mrl ()->title = title;
    }
    Mrl::closed ();
}

KMPLAYER_NO_EXPORT Mrl * RSS::Item::linkNode () {
    if (enclosure)
        return enclosure->mrl ();
    return Mrl::linkNode ();
}

String RSS::Item::description () const {
    for (Node *c = firstChild (); c; c = c->nextSibling ())
        if (c->id == id_node_description)
            return c->innerText ();
    return String ();
}

KMPLAYER_NO_EXPORT void RSS::Item::activate () {
    String s = description ();
    if (!enclosure && !s.isEmpty ()) {
        setState (state_activated);
        begin ();
        timer = document ()->post (this,
                new TimerPosting (5000+s.length()*200));
        return;
    }
    Mrl::activate ();
}

KDE_NO_EXPORT void RSS::Item::deactivate () {
    if (timer) {
        document ()->cancelPosting (timer);
        timer = 0L;
    }
    document ()->message (MsgInfoString, NULL);
    Mrl::deactivate ();
}

KDE_NO_EXPORT void *RSS::Item::message (MessageType msg, void *content) {
    if (msg == MsgEventTimer) {
        timer = 0L;
        finish ();
        return NULL;
    }
    return Mrl::message (msg, content);
}

KDE_NO_EXPORT void RSS::Enclosure::closed () {
    src = getAttribute (StringPool::attr_url);
    Mrl::closed ();
}
