#include "progressbox.h"

typedef struct sProgressBoxClass
{
	GtkHBoxClass parent_class;
} ProgressBoxClass;

typedef struct sProgressBoxPrivate
{
	gdouble progress;
} ProgressBoxPrivate;

static void progressbox_realize(GtkWidget *pbox);
static gboolean progressbox_expose(GtkWidget *pbox, GdkEventExpose *event);
static void progressbox_paint(ProgressBox *pbox);
static void progressbox_finalize(GObject *object);

G_DEFINE_TYPE(ProgressBox, progressbox, GTK_TYPE_HBOX)

void progressbox_class_init(ProgressBoxClass *pbc)
{
	GtkWidgetClass *wdg_class;
	GObjectClass *object_class;

	wdg_class=(GtkWidgetClass *)pbc;
	object_class=(GObjectClass *)pbc;

	wdg_class->realize=progressbox_realize;
	wdg_class->expose_event=progressbox_expose;

	object_class->finalize=progressbox_finalize;
}

void progressbox_init(ProgressBox *pbox)
{
	ProgressBoxPrivate *priv;

	priv=pbox->priv=g_malloc(sizeof(ProgressBoxPrivate));

	priv->progress=0.0;
}

GtkWidget *progressbox_new(gboolean homogeneous, guint spacing)
{
	ProgressBox *pbox;

	pbox=g_object_new(TYPE_PROGRESSBOX, NULL);

	GTK_BOX(pbox)->homogeneous=(homogeneous ? TRUE : FALSE);
	GTK_BOX(pbox)->spacing=spacing;

	return GTK_WIDGET(pbox);
}

void progressbox_set_progress(ProgressBox *pbox, gdouble p)
{
	pbox->priv->progress=p;
	gtk_widget_queue_draw(GTK_WIDGET(pbox));
}

static void progressbox_realize(GtkWidget *wdg)
{
	GTK_WIDGET_SET_FLAGS(wdg, GTK_REALIZED);

	wdg->window=gtk_widget_get_parent_window(wdg);
	g_object_ref(wdg->window);

	wdg->style=gtk_style_attach(wdg->style, wdg->window);
}

static void progressbox_paint(ProgressBox *pbox)
{
	if(GTK_WIDGET_DRAWABLE(pbox) && pbox->priv->progress>=0)
	{
		GtkWidget *wdg;
		ProgressBoxPrivate *priv;
		GdkRectangle rect;

		wdg=GTK_WIDGET(pbox);
		priv=pbox->priv;

		rect.x=wdg->allocation.x;
		rect.width=wdg->allocation.width;
		rect.y=wdg->allocation.y;
		rect.height=wdg->allocation.height;

		gtk_paint_box(wdg->style, wdg->window, GTK_STATE_PRELIGHT, GTK_SHADOW_IN, &rect, wdg, "trough", rect.x, rect.y, rect.width, rect.height);

		rect.x+=wdg->style->xthickness;
		rect.width=15+(unsigned)(priv->progress*(wdg->allocation.width-wdg->style->xthickness*2-15));
		rect.y+=wdg->style->ythickness;
		rect.height-=wdg->style->ythickness*2;

		gtk_paint_box(wdg->style, wdg->window, GTK_STATE_PRELIGHT, GTK_SHADOW_OUT, &rect, wdg, "bar", rect.x, rect.y, rect.width, rect.height);
	}
}

gboolean progressbox_expose(GtkWidget *wdg, GdkEventExpose *event)
{
	if(GTK_WIDGET_DRAWABLE(wdg))
	{
		progressbox_paint(PROGRESSBOX(wdg));
		(*GTK_WIDGET_CLASS(progressbox_parent_class)->expose_event)(wdg, event);
	}

	return FALSE;
}

/* GObject stuff */
static void progressbox_finalize(GObject *object)
{
	ProgressBoxPrivate *priv;

	priv=PROGRESSBOX(object)->priv;

	g_free(priv);
}

