/*
 * * Copyright (C) 2007 Joni Valtanen <jvaltane@kapsi.fi>
 *                    Tuomas Kulve <tuomas@kulve.fi>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 * USA.
 */

#ifndef KILIKALI_H_
#define KILIKALI_H_

#include <glib/gstring.h>
#include <glib/gtypes.h>
#include <libgnomevfs/gnome-vfs.h>

enum
{
    COL_ARTIST = 0,
    COL_SONG,
    COL_ALBUM,
    COL_FULLPATH,
    COL_UIDATA,
    NUM_COLS
};

extern gint icon_size;

/*
 * Standard gettext macros.
 */
#ifdef ENABLE_NLS
#  include <libintl.h>
#  undef _
#  define _(String) dgettext (PACKAGE, String)
#  define Q_(String) g_strip_context ((String), gettext (String))
#  ifdef gettext_noop
#    define N_(String) gettext_noop (String)
#  else
#    define N_(String) (String)
#  endif
#else
#  define textdomain(String) (String)
#  undef gettext
#  define gettext(String) (String)
#  undef dgettext
#  define dgettext(Domain,Message) (Message)
#  define dcgettext(Domain,Message,Type) (Message)
#  define bindtextdomain(Domain,Directory) (Domain)
#  define _(String) (String)
#  define Q_(String) g_strip_context ((String), (String))
#  define N_(String) (String)
#endif


/*
 * Initiate exiting.
 */
void kilikali_quit(void);

#endif



/* Emacs indentatation information
 * Local Variables:
 * c-file-style:"stroustrup"
 * c-basic-offset:4
 * indent-tabs-mode:nil
 * End:
 */
