/*
 * * Copyright (C) 2007 Joni Valtanen <jvaltane@kapsi.fi>
 *                      Tuomas Kulve <tuomas@kulve.fi>
 *                      Kalle Vahlman <zuh@iki.fi>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 * USA.
 */


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#ifdef ENABLE_NLS
# include <locale.h>
#endif

#include "kilikali.h"
#include "kilikali-audio.h"
#include "kilikali-audio-gst.h"
#include "kilikali-vfs.h"
#include "kilikali-ui.h"
#include "kilikali-osso.h"
#include "playlist.h"

#include <gtk/gtk.h>
#include <getopt.h>              /* getopt */
#include <string.h>              /* strdup */
#include <libgconf-bridge/gconf-bridge.h> /* GConfBridge */

#ifdef ENABLE_NLS
#include <locale.h>
#endif

#define GCONF_KILIKALI "/apps/kilikali"
#define GCONF_KEY_VOLUME GCONF_KILIKALI "/volume"
#define GCONF_PATH_WINDOW GCONF_KILIKALI "/window/"

static void parse_args(int argc, char *argv[], char **playfile);

gint icon_size = GTK_ICON_SIZE_INVALID;

int
main (int argc, char *argv[])
{
    /* Audio interface controller */
    KilikaliAudio *audio = NULL;
    /* VFS controller */
    KilikaliVFS *vfs = NULL;
    /* UI controller */
    KilikaliUI *ui = NULL;
    /* Model for common data */
    GtkTreeModel *model;
    gchar *playfile = NULL;
    /* GConfBridge to easy loading and saving properties */
    GConfBridge *bridge;
    guint window_id;
    guint volume_id;


#ifdef ENABLE_NLS
    setlocale(LC_ALL, "");
    bindtextdomain (PACKAGE, PACKAGE_LOCALE_DIR);
    bind_textdomain_codeset (PACKAGE, "UTF-8");
    textdomain (PACKAGE);
#endif

    gst_init (&argc, &argv);
    gtk_init (&argc, &argv);

    gtk_rc_parse(PACKAGE_DATA_DIR "/theme/gtkrc");
    icon_size = gtk_icon_size_register("kilikali", 48, 48);

    parse_args(argc, argv, &playfile);

    /* Setup audio object */
#ifdef NOKIA_INTERNET_TABLET
    audio = KILIKALI_AUDIO(g_object_new (KILIKALI_TYPE_AUDIO_GST,
                                         "device", "default",/* FIXME: unused */
                                         "sink", "dsppcmsink", 
                                         NULL));
#else
    audio = KILIKALI_AUDIO(g_object_new (KILIKALI_TYPE_AUDIO_GST,
                                         "device", "default",/* FIXME: unused */
                                         NULL));
#endif
    /* Bind media object to GConfBridge */
    bridge = gconf_bridge_get ();
    volume_id = gconf_bridge_bind_property (bridge, GCONF_KEY_VOLUME,
                                            audio, "volume");


    model = GTK_TREE_MODEL(gtk_list_store_new (NUM_COLS,
                                                G_TYPE_STRING,
                                                G_TYPE_STRING,
                                                G_TYPE_STRING,
                                                G_TYPE_STRING,
                                                G_TYPE_POINTER));

    vfs = KILIKALI_VFS(g_object_new(KILIKALI_TYPE_VFS,
                                    "model", model,
                                    NULL));

    ui = KILIKALI_UI(g_object_new(KILIKALI_TYPE_UI,
                                  "model", model,
                                  "audio", audio,
                                  NULL));
    /* Bind window to GConfBridge */
    window_id = gconf_bridge_bind_window (bridge, GCONF_PATH_WINDOW,
                                          ui->toplevel, 
                                          TRUE, TRUE); 

    /* Play uri given as argument */
    if (playfile != NULL) {
        g_idle_add(vfs_add_file_from_idle, vfs_modeluri(model, playfile));
        /* FIXME: implement user setting for this */
    } else if (TRUE) {
        /* load auto playlist if a file is not given as argument. */
        playlist_auto_load(model);
    }

#ifdef USE_HILDON
    if (!kilikali_osso_init(ui)) {
        g_error("Failed to init osso stuff");
        return 1;
    }

    g_idle_add(kilikali_osso_start_sb, NULL);
#endif

    gtk_widget_show (ui->toplevel);
    gtk_main ();

    /* FIXME: implement user setting for this */
    if (TRUE) {
        /* save auto playlist */
        playlist_auto_save(model);
    }

#ifdef USE_HILDON
    kilikali_osso_stop_sb(NULL);
#endif

    /* Unbind GConfBridge values. 
     * Not sure is this really mandatory 
     */
    gconf_bridge_unbind (bridge, window_id);
    gconf_bridge_unbind (bridge, volume_id);

    g_object_unref(audio);
    g_object_unref(ui);

#ifdef USE_HILDON
    kilikali_osso_deinit();
#endif

    return 0;
}



void kilikali_quit(void)
{
    gtk_main_quit();
}



static void parse_args(int argc, char *argv[], char **playfile)
{
    int c;

    while (1) {
        int option_index = 0;
        struct option long_options[] = {
            {"help", 0, 0, 'h'},
            {0, 0, 0, 0}
        };
        
        c = getopt_long (argc, argv, "h",
                         long_options, &option_index);
        if (c == -1)
            break;
        
        switch (c) {
        case 'h':
            printf("Usage: %s [uri of a file to play]\n", argv[0]);
            exit(-1);
            break;       
        default:
            printf ("?? getopt returned character code 0%o ??\n", c);
        }
    }
    
    if (optind < argc) {
        *playfile = strdup(argv[optind]);
        g_debug("file to play: %s", *playfile);
    }
}



/* Emacs indentatation information
 * Local Variables:
 * c-file-style:"stroustrup"
 * c-basic-offset:4
 * indent-tabs-mode:nil
 * End:
 */

