/*
 * * Copyright (C) 2007 Tuomas Kulve <tuomas@kulve.fi>
 *                      Kalle Vahlman <zuh@iki.fi>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Svfste 330, Boston, MA 02111-1307,
 * USA.
 */

#ifndef KILIKALI_VFS_H
#define KILIKALI_VFS_H

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtkliststore.h>

G_BEGIN_DECLS

/************************************/
/* GObject for async VFS operations */
/************************************/

#define KILIKALI_TYPE_VFS     (kilikali_vfs_get_type ())
#define KILIKALI_VFS(obj)     (G_TYPE_CHECK_INSTANCE_CAST ((obj), KILIKALI_TYPE_VFS, KilikaliVFS))
#define KILIKALI_IS_VFS(obj)  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KILIKALI_TYPE_VFS))
#define KILIKALI_VFS_CLASS(klass)	  (G_TYPE_CHECK_CLASS_CAST ((klass), KILIKALI_TYPE_VFS, KilikaliVFSClass))
#define KILIKALI_IS_VFS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KILIKALI_TYPE_VFS))
#define KILIKALI_VFS_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), KILIKALI_TYPE_VFS, KilikaliVFSClass))

typedef struct _KilikaliVFS KilikaliVFS;
typedef struct _KilikaliVFSClass KilikaliVFSClass;
typedef struct _KilikaliVFSPrivate KilikaliVFSPrivate;

struct _KilikaliVFSClass
{
    GObjectClass parent;

    guint finished_signal_id;
};

struct _KilikaliVFS
{
  GObject parent;

  KilikaliVFSPrivate *private;
};

KilikaliVFS *kilikali_vfs_new (void);
GType  kilikali_vfs_get_type (void);


/***********************/
/* Public sync VFS API */
/***********************/


/* struct just for passing two args for g_idle_add  */
struct modeluri {
    GtkTreeModel *model;
    gchar *uri;
};


/*
 * Convenient function to build modeluri struct. Returns struct
 * modeluri casted to gpointer. Copies the uri.
 */
gpointer vfs_modeluri(GtkTreeModel *model, const gchar *uri);

/*
 * Convenient function to be used with g_idle_add(). The gpointer is
 * casted to struct modeluri and the vfs_add_file() is called.
 */
gboolean vfs_add_file_from_idle(gpointer data);


/*
 * Add single file. Frees the struct.
 */
void vfs_add_file(struct modeluri *mu);

/*
 * Load entire file in to memory. Content must be freed by the caller.
 */
gboolean vfs_load_content(const gchar *uri, gint *size, gchar **content);

/*
 * Save to file. Content must be freed by the caller.
 */
gboolean vfs_save_content(const gchar *uri, gint size, gchar *content);

G_END_DECLS

#endif

/* Emacs indentatation information
   Local Variables:
   indent-tabs-mode:nil
   tab-width:4
   c-set-offset:4
   c-basic-offset:4
   End: 
*/
// vim: filetype=c:expandtab:shiftwidth=4:tabstop=4:softtabstop=4

