/*
 * * Copyright (C) 2007 Kalle Vahlman <zuh@iki.fi>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 * USA.
 */

#ifndef _KILIKALI_UI_H_
#define _KILIKALI_UI_H_

#ifdef USE_HILDON
#include "kilikali-plugin.h"
#endif

#include <glib-object.h>
#include <gtk/gtk.h>

#ifdef USE_HILDON
#ifdef USE_IT2008OS
#include <hildon/hildon-program.h>
#else
#include <hildon-widgets/hildon-program.h>
#endif
#endif 

/* In ms */
#define KILIKALI_SEEK_STEP_SMALL 10000
#define KILIKALI_SEEK_STEP_LARGE 30000

G_BEGIN_DECLS

#define KILIKALI_TYPE_UI     (kilikali_ui_get_type ())
#define KILIKALI_UI(obj)     (G_TYPE_CHECK_INSTANCE_CAST ((obj), KILIKALI_TYPE_UI, KilikaliUI))
#define KILIKALI_IS_UI(obj)  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KILIKALI_TYPE_UI))
#define KILIKALI_UI_CLASS(klass)	  (G_TYPE_CHECK_CLASS_CAST ((klass), KILIKALI_TYPE_UI, KilikaliUIClass))
#define KILIKALI_IS_UI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KILIKALI_TYPE_UI))
#define KILIKALI_UI_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), KILIKALI_TYPE_UI, KilikaliUIClass))

typedef struct _KilikaliUI KilikaliUI;
typedef struct _KilikaliUIClass KilikaliUIClass;
typedef struct _KilikaliUIPrivate KilikaliUIPrivate;

struct _KilikaliUIClass
{
  GObjectClass parent;

};

struct _KilikaliUI
{
  GObject parent;

  /* Please treat these as read-only! */
  GtkWidget *toplevel;

#ifdef USE_HILDON
  HildonProgram *program;
#endif

  KilikaliUIPrivate *private;
};

KilikaliUI *kilikali_ui_new (void);
GType  kilikali_ui_get_type (void);

/*
 * Called from dbus handler.
 */
#ifdef USE_HILDON
void kilikali_ui_action(KilikaliUI *ui, kilikali_plugin_t action);
#endif

/* Public API */

G_END_DECLS

#endif /* _KILIKALI_UI_H_ */
