/*
 * * Copyright (C) 2007 Tuomas Kulve <tuomas@kulve.fi>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 * USA.
 */

#ifndef KILIKALI_PLUGIN_H
#define KILIKALI_PLUGIN_H

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <libosso.h>

typedef enum {
  KILIKALI_PLUGIN_ACTION_INVALID = 0,
  KILIKALI_PLUGIN_ACTION_NEXT,
  KILIKALI_PLUGIN_ACTION_PREV,
  KILIKALI_PLUGIN_ACTION_PLAY,
  KILIKALI_PLUGIN_ACTION_PAUSE,
  KILIKALI_PLUGIN_ACTION_STOP
} kilikali_plugin_t;
  

#define KILIKALI_DBUS_SERVICE           "com.nokia.kilikali"
#define KILIKALI_DBUS_OBJECT_PATH       "/com/nokia/kilikali"
#define KILIKALI_DBUS_INTERFACE         "com.nokia.kilikali"

#define KILIKALISB_DBUS_SERVICE           "com.nokia.kilikalisb"
#define KILIKALISB_DBUS_OBJECT_PATH       "/com/nokia/kilikalisb"
#define KILIKALISB_DBUS_INTERFACE         "com.nokia.kilikalisb"

/*
 * Send dbus signal to kilikali: next
 */
void kilikali_plugin_next(osso_context_t *osso);



/*
 * Send dbus signal to kilikali: prev
 */
void kilikali_plugin_prev(osso_context_t *osso);



/*
 * Send dbus signal to kilikali: play
 */
void kilikali_plugin_play(osso_context_t *osso);



/*
 * Send dbus signal to kilikali: pause
 */
void kilikali_plugin_pause(osso_context_t *osso);



/*
 * Send dbus signal to kilikali: stop
 */
void kilikali_plugin_stop(osso_context_t *osso);


#endif

/* Emacs indentatation information
   Local Variables:
   indent-tabs-mode:nil
   tab-width:4
   c-set-offset:4
   c-basic-offset:4
   End: 
*/
