/*
 * * Copyright (C) 2007 Tuomas Kulve <tuomas@kulve.fi>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 * USA.
 */


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include "kilikali-plugin.h"

#include <glib.h>
#include <libosso.h>
#include <dbus/dbus.h>
#include <dbus/dbus-glib.h>
#include <dbus/dbus-glib-lowlevel.h>


static void plugin_rpc(osso_context_t *osso, kilikali_plugin_t action);


void
kilikali_plugin_next(osso_context_t *osso)
{
    g_debug("next");
    plugin_rpc(osso, KILIKALI_PLUGIN_ACTION_NEXT);
}



void
kilikali_plugin_prev(osso_context_t *osso)
{
    g_debug("prev");
    plugin_rpc(osso, KILIKALI_PLUGIN_ACTION_PREV);
}



void
kilikali_plugin_play(osso_context_t *osso)
{
    g_debug("play");
    plugin_rpc(osso, KILIKALI_PLUGIN_ACTION_PLAY);
}



void
kilikali_plugin_pause(osso_context_t *osso)
{
    g_debug("pause");
    plugin_rpc(osso, KILIKALI_PLUGIN_ACTION_PAUSE);
}



void
kilikali_plugin_stop(osso_context_t *osso)
{
    g_debug("stop");
    plugin_rpc(osso, KILIKALI_PLUGIN_ACTION_STOP);
}



void
plugin_rpc(osso_context_t *osso, kilikali_plugin_t action)
{
    DBusConnection* conn;
    DBusMessage* msg;

    conn = osso_get_dbus_connection(osso);
    if (!conn) {
        g_warning ("Failed to get the D-BUS connection");
        return;
    }
    
    /* create a signal and check for errors  */
    msg = dbus_message_new_signal
        ("/org/freedesktop/MusicPlayer", /* object name of the signal */
         "org.freedesktop.MusicPlayer", /* interface name of the signal */
         "action");                     /* name of the signal */
    if (msg == NULL) { 
        g_warning("Failed to create dbus message"); 
        return;
    }

   /* append arguments onto signal */
    dbus_message_append_args(msg,
                             DBUS_TYPE_INT32, &action,
                             DBUS_TYPE_INVALID);

   /* send the message and flush the connection */
   if (!dbus_connection_send(conn, msg, NULL)) { 
       g_warning("Failed to send dbus msg"); 
      return;
   }

   dbus_connection_flush(conn);

   /* free the message */
   dbus_message_unref(msg);

}



/* Emacs indentatation information
   Local Variables:
   indent-tabs-mode:nil
   tab-width:4
   c-set-offset:4
   c-basic-offset:4
   End: 
*/
// vim: filetype=c:expandtab:shiftwidth=4:tabstop=4:softtabstop=4

