/*
 * * Copyright (C) 2007 Tuomas Kulve <tuomas@kulve.fi>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 * USA.
 */

#ifndef KILIKALI_OSSO_H
#define KILIKALI_OSSO_H

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include "kilikali-ui.h"

#include <glib.h>
#include <gtk/gtk.h>

/*
 * Init osso related stuff. Returns true on success.
 */
gboolean kilikali_osso_init(KilikaliUI *ui);


/*
 * Deinit osso related stuff.
 */
void kilikali_osso_deinit(void);


/*
 * Send signal to load kilikali status bar plugin.
 */
gboolean kilikali_osso_start_sb(gpointer data);


/*
 * Send signal to unload kilikali status bar plugin.
 */
gboolean kilikali_osso_stop_sb(gpointer data);

/* Inhibit / allow blanking of the screen */
void kilikali_osso_inhibit_blanking(void);
void kilikali_osso_allow_blanking(void);

#endif

/* Emacs indentatation information
   Local Variables:
   indent-tabs-mode:nil
   tab-width:4
   c-set-offset:4
   c-basic-offset:4
   End: 
*/
