/*
 * * Copyright (C) 2007 Tuomas Kulve <tuomas@kulve.fi>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 * USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include "kilikali-plugin.h"

#include <hildon-home-plugin/hildon-home-plugin-interface.h>
#include <libosso.h>
#include <glib.h>
#include <gtk/gtk.h>

#define APPLET_X_SIZE 100
#define APPLET_Y_SIZE 100

struct kilikali_plugin {
    osso_context_t *osso;
};

static void play_clicked(GtkButton* button, gpointer data);
static void stop_clicked(GtkButton* button, gpointer data);
static void next_clicked(GtkButton* button, gpointer data);
static void prev_clicked(GtkButton* button, gpointer data);
static GtkWidget* ui_create(struct kilikali_plugin *kilikali);
static void ui_quit(void);

void* 
hildon_home_applet_lib_initialize (void *state_data,
                                   int *state_size, 
                                   GtkWidget **widget)
{ 
    struct kilikali_plugin *kilikali;

    kilikali = g_new0(struct kilikali_plugin, 1);
    
    /* Initialize libosso */
    kilikali->osso = osso_initialize ("kilikalihome", "0.1", FALSE, NULL);
    if (!kilikali->osso) {
        g_debug ("Error initializing the kilikalihome applet");
        return NULL;
    }
    
    (*widget) = ui_create(kilikali);
    
    g_debug ("Initialized kilikalihome");

    return (void*)kilikali;
}


static void
play_clicked(GtkButton *button, gpointer user_data)
{
    struct kilikali_plugin *kilikali;
    g_return_if_fail(user_data != NULL);

    kilikali = user_data;
    kilikali_plugin_play(kilikali->osso);
}



static void
stop_clicked(GtkButton *button, gpointer user_data)
{
    struct kilikali_plugin *kilikali;
    g_return_if_fail(user_data != NULL);

    kilikali = user_data;
    kilikali_plugin_stop(kilikali->osso);
}



static void
next_clicked(GtkButton *button, gpointer user_data)
{
    struct kilikali_plugin *kilikali;
    g_return_if_fail(user_data != NULL);

    kilikali = user_data;
    kilikali_plugin_next(kilikali->osso);
}



static void
prev_clicked(GtkButton *button, gpointer user_data)
{
    struct kilikali_plugin *kilikali;
    g_return_if_fail(user_data != NULL);

    kilikali = user_data;
    kilikali_plugin_prev(kilikali->osso);
}



static GtkWidget*
ui_create(struct kilikali_plugin *kilikali)
{
    GtkWidget *box;
    GtkWidget *button;
    GtkWidget *image;
    GtkIconTheme *theme;
    GdkPixbuf *pixbuf;
    int icon_size = 64;
    /* FIXME: hack */
    gchar *stock_icons[] = {"qgn_widg_mplayer_play",
                            "qgn_widg_mplayer_stop",
                            "qgn_widg_mplayer_rew",
                            "qgn_widg_mplayer_fwd",};

    gchar *tango_icons[] = {"media-playback-start",
                            "media-playback-stop",
                            "media-skip-backward",
                            "media-skip-forward"};
    gchar *icons[4];

    gtk_rc_parse_string("style \"kilikali-home-button\" {\n"
                        "  GtkButton::default_border = { 0, 0, 0, 0 }\n"
                        "  GtkButton::default_outside_border = { 0, 0, 0, 0 }\n"
                        "  GtkButton::child_spacing = 0\n"
                        "  xthickness = 0\n"
                        "  ythickness = 0\n"
                        "  engine \"sapwood\" {\n"
                        "    image {\n"
                        "      function = BOX\n"
                        "      state = ACTIVE\n"
                        "    }\n"
                        "    image {\n"
                        "      function = BOX\n"
                        "    }\n"
                        "  }\n"
                        "}\n"
                        "widget \"*.KilikaliHomeButton\" style \"kilikali-home-button\"\n");
                        

    /* Set icon theme */
    theme = gtk_icon_theme_new();
    gtk_icon_theme_set_custom_theme(theme, "Tango");

    /* FIXME: hack */
    icons[0] = tango_icons[0];
    icons[1] = tango_icons[1];
    icons[2] = tango_icons[2];
    icons[3] = tango_icons[3];

    if (!gtk_icon_theme_has_icon(theme, GTK_STOCK_REFRESH)) {
        gtk_icon_theme_set_custom_theme(theme, NULL);
        icons[0] = stock_icons[0];
        icons[1] = stock_icons[1];
        icons[2] = stock_icons[2];
        icons[3] = stock_icons[3];
        icon_size = 26;
    }

    box = gtk_hbox_new(TRUE, 0);

    /* play button */
    pixbuf = gtk_icon_theme_load_icon(theme,
                                      icons[0],
                                      icon_size,
                                      GTK_ICON_LOOKUP_NO_SVG,
                                      NULL);
    image = gtk_image_new_from_pixbuf(pixbuf); 
    button = gtk_button_new();
    gtk_widget_set_name(button, "KilikaliHomeButton");
    gtk_container_add(GTK_CONTAINER(button), image);
    gtk_signal_connect(GTK_OBJECT(button), "clicked",
                       GTK_SIGNAL_FUNC(play_clicked), kilikali);
    gtk_box_pack_start(GTK_BOX(box), button, TRUE, TRUE, 0);

    /* stop button */
    pixbuf = gtk_icon_theme_load_icon(theme,
                                      icons[1],
                                      icon_size,
                                      GTK_ICON_LOOKUP_NO_SVG,
                                      NULL);
    image = gtk_image_new_from_pixbuf(pixbuf); 
    button = gtk_button_new();
    gtk_widget_set_name(button, "KilikaliHomeButton");
    gtk_container_add(GTK_CONTAINER(button), image);
    gtk_signal_connect(GTK_OBJECT(button), "clicked",
                       GTK_SIGNAL_FUNC(stop_clicked), kilikali);
    gtk_box_pack_start(GTK_BOX(box), button, TRUE, TRUE, 0);

    /* prev button */
    pixbuf = gtk_icon_theme_load_icon(theme,
                                      icons[2],
                                      icon_size,
                                      GTK_ICON_LOOKUP_NO_SVG,
                                      NULL);
    image = gtk_image_new_from_pixbuf(pixbuf); 
    button = gtk_button_new();
    gtk_widget_set_name(button, "KilikaliHomeButton");
    gtk_container_add(GTK_CONTAINER(button), image);
    gtk_signal_connect(GTK_OBJECT(button), "clicked",
                       GTK_SIGNAL_FUNC(prev_clicked), kilikali);
    gtk_box_pack_start(GTK_BOX(box), button, TRUE, TRUE, 0);

    /* next button */
    pixbuf = gtk_icon_theme_load_icon(theme,
                                      icons[3],
                                      icon_size,
                                      GTK_ICON_LOOKUP_NO_SVG,
                                      NULL);
    image = gtk_image_new_from_pixbuf(pixbuf); 
    button = gtk_button_new();
    gtk_widget_set_name(button, "KilikaliHomeButton");
    gtk_container_add(GTK_CONTAINER(button), image);
    gtk_signal_connect(GTK_OBJECT(button), "clicked",
                       GTK_SIGNAL_FUNC(next_clicked), kilikali);
    gtk_box_pack_start(GTK_BOX(box), button, TRUE, TRUE, 0);

    gtk_widget_show_all(GTK_WIDGET(box));

    return box;
}


static void
ui_quit (void) {
    return;
}

void
hildon_home_applet_lib_background (void *applet_data)
{
    return;
}



void 
hildon_home_applet_lib_foreground (void *applet_data)
{
    return;
}



int 
hildon_home_applet_lib_save_state (void *applet_data,
								   void **state_data, 
								   int *state_size)
{
    *state_data = NULL;
    *state_size = 0;
    return 0;
}



GtkWidget*
hildon_home_applet_lib_settings (void *applet_data,
								 GtkWindow *parent)
{
    return NULL;
}



void 
hildon_home_applet_lib_deinitialize (void *applet_data)
{
    struct kilikali_plugin *kilikali = applet_data;

    ui_quit ();

    /* Deinitialize libosso */
    osso_deinitialize(kilikali->osso);
}



/* Emacs indentatation information
   Local Variables:
   indent-tabs-mode:nil
   tab-width:4
   c-set-offset:4
   c-basic-offset:4
   End: 
*/
// vim: filetype=c:expandtab:shiftwidth=4:tabstop=4:softtabstop=4

