/*
 * * Copyright (C) 2007 Joni Valtanen <jvaltane@kapsi.fi>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 * USA.
 */

#ifndef _KILIKALI_BASE_BIN_
#define _KILIKALI_BASE_BIN_

#include <gst/gst.h>

G_BEGIN_DECLS

#define KILIKALI_TYPE_BASE_BIN               (kilikali_base_bin_get_type())
#define KILIKALI_BASE_BIN(obj)               (G_TYPE_CHECK_INSTANCE_CAST((obj),KILIKALI_TYPE_BASE_BIN,KilikaliBaseBin))
#define KILIKALI_BASE_BIN_CLASS(klass)     (G_TYPE_CHECK_CLASS_CAST((klass),KILIKALI_TYPE_BASE_BIN,KilikaliBaseBinClass))
#define KILIKALI_IS_BASE_BIN(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj),KILIKALI_TYPE_BASE_BIN))
#define KILIKALI_IS_BASE_BIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass),KILIKALI_TYPE_BASE_BIN))

typedef struct _KilikaliBaseBin KilikaliBaseBin;
typedef struct _KilikaliBaseBinClass KilikaliBaseBinClass;

struct _KilikaliBaseBinClass
{
    GstPipelineClass parent_class;
};

struct _KilikaliBaseBin 
{
    GstPipeline parent;

    gchar *uri;
    gchar *iradioname;

    GList *factories;


    GstBin *audiobin;

    GstElement *queue;
    GstElement *sink;
    GstElement *volumeelem;
    GstElement *fakesink;
    GstElement *siddec;

    GstElement *colorspace;
    GstElement *videosink;
    GstElement *vqueue;


    GHashTable *elements; /* Elements of the pipeline */
    
#if 0
    gulong pushing_id;
#endif

    void (*set_volume)(KilikaliBaseBin *base_bin, gdouble volume);
    void (*set_mute)(KilikaliBaseBin *base_bin, gboolean mute);
};


GType kilikali_base_bin_get_type (void);


G_END_DECLS

#endif

/* Emacs indentatation information
   Local Variables:
   indent-tabs-mode:nil
   tab-width:4
   c-set-offset:4
   c-basic-offset:4
   End: 
*/
// vim: filetype=c:expandtab:shiftwidth=4:tabstop=4:softtabstop=4
