/*
 * * Copyright (C) 2007 Joni Valtanen <jvaltane@kapsi.fi>
 *                    Tuomas Kulve <tuomas@kulve.fi>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 * USA.
 */

#ifndef KILIKALI_AUDIO_H_
#define KILIKALI_AUDIO_H_

#include <glib-object.h>
#include <glib/gtypes.h>

G_BEGIN_DECLS

#define KILIKALI_TAG_ARTIST "artist"
#define KILIKALI_TAG_ALBUM "album"
#define KILIKALI_TAG_TITLE "title"
#define KILIKALI_TAG_DURATION "duration"
#define KILIKALI_TAG_TRACK_NUMBER "tracknumber"
#define KILIKALI_TAG_TRACK_COUNT  "trackcount"
#define KILIKALI_TAG_BITRATE "bitrate"
#define KILIKALI_TAG_AUDIO_CODEC "audiocodec"
#define KILIKALI_TAG_COMMENT "comment"


/* properties */
enum {
    KILIKALI_AUDIO_DEVICE = 1,
    KILIKALI_AUDIO_URI,
    KILIKALI_AUDIO_SINK,
    KILIKALI_AUDIO_STATE,
    KILIKALI_AUDIO_VOLUME,
    KILIKALI_AUDIO_MUTE,
    KILIKALI_AUDIO_MIME_TYPE,
    KILIKALI_AUDIO_IRADIONAME,
    KILIKALI_AUDIO_POSITION,
    KILIKALI_AUDIO_LENGTH,
    KILIKALI_AUDIO_SID_TIME,
    KILIKALI_AUDIO_SID_TUNE,
    KILIKALI_AUDIO_SID_CLOCK,
    KILIKALI_AUDIO_SID_MEMORY,
    KILIKALI_AUDIO_SID_FILTER,
    KILIKALI_AUDIO_SID_MEASURED_VOLUME,
    KILIKALI_AUDIO_SID_MOS8580,
    KILIKALI_AUDIO_SID_FORCE_SPEED,
    KILIKALI_AUDIO_XID,
    KILIKALI_AUDIO_TAGS
};

/* audio states */
enum _kilikali_audio_states
{
    AUDIO_STATE_VOID,
    AUDIO_STATE_PLAYING,
    AUDIO_STATE_STOPPED,
    AUDIO_STATE_PAUSED,
    AUDIO_STATE_LAST,
};

typedef enum _kilikali_audio_states kilikali_audio_states;


#define KILIKALI_TYPE_AUDIO     ( kilikali_audio_get_type() )
#define KILIKALI_AUDIO(obj)     (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
                                KILIKALI_TYPE_AUDIO, KilikaliAudio))
#define KILIKALI_IS_AUDIO(obj)  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
                                KILIKALI_TYPE_AUDIO))
#define KILIKALI_AUDIO_GET_IFACE(obj)  (G_TYPE_INSTANCE_GET_INTERFACE ((obj), \
                                KILIKALI_TYPE_AUDIO, KilikaliAudioInterface))

typedef struct _KilikaliAudio KilikaliAudio;
typedef struct _KilikaliAudioInterface KilikaliAudioInterface;

typedef struct _KilikaliAudioTags KilikaliAudioTags;

struct _KilikaliAudioInterface {
    GTypeInterface g_iface;

    /* virtual methods  */
    gboolean (*init) (KilikaliAudio *self);
    void (*deinit) (KilikaliAudio *self);

    void (*play) (KilikaliAudio *self);
    void (*stop) (KilikaliAudio *self);
    void (*pause) (KilikaliAudio *self);

    void (*absolute) (KilikaliAudio *self, gulong time);

    gulong (*get_current_time) (KilikaliAudio *self);
    gulong (*get_current_length) (KilikaliAudio *self);

    gboolean (*is_supported) (KilikaliAudio *self, const gchar *uri);

    kilikali_audio_states state;

    /* Signals */
    guint state_changed_signal_id;
    guint eos_signal_id;
    guint type_unknown_signal_id;
    guint sid_playing_signal_id;
    guint video_playing_signal_id;
    guint position_signal_id;
    guint length_signal_id;
    guint tag_found_signal_id;

};

struct _KilikaliAudioTags
{
    gchar *artist;
    gchar *album;
    gchar *title;

    /* FIXME: FILL ME */
};

/* virtual methods  */
GType kilikali_audio_get_type (void);
KilikaliAudio *kilikali_audio_new ( void );

gboolean kilikali_audio_init (KilikaliAudio *self);
void kilikali_audio_deinit (KilikaliAudio *self);

void kilikali_audio_play (KilikaliAudio *self);
void kilikali_audio_stop (KilikaliAudio *self);
void kilikali_audio_pause (KilikaliAudio *self);

void kilikali_audio_forward (KilikaliAudio *self, gulong time);
void kilikali_audio_backward (KilikaliAudio *self, gulong time);
void kilikali_audio_absolute (KilikaliAudio *self, gulong time);

gboolean kilikali_audio_is_supported ( KilikaliAudio *self, 
                                       const gchar *uri);

/* Signals */
void kilikali_audio_state_changed (KilikaliAudio *self);

G_END_DECLS

#endif /* _KILIKALI_AUDIO_H_ */


/* Emacs indentatation information
 * Local Variables:
 * c-file-style:"stroustrup"
 * c-basic-offset:4
 * indent-tabs-mode:nil
 * End:
 */
