/*
 * * Copyright (C) 2007 Joni Valtanen <jvaltane@kapsi.fi>
 *                    Tuomas Kulve <tuomas@kulve.fi>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 * USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include "kilikali-audio.h"


#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <glib/gtypes.h>
#include <glib/gstring.h>


/* signals */

static void 
kilikali_audio_interface_init (KilikaliAudioInterface *iface)
{
    GParamSpec *pspec;
    static gboolean initialized = FALSE;

    if (!initialized) {
        iface->eos_signal_id = 
            g_signal_newv ("audio-eos",
                           G_TYPE_FROM_INTERFACE (iface),
                           G_SIGNAL_RUN_LAST | G_SIGNAL_NO_RECURSE | 
                           G_SIGNAL_NO_HOOKS,
                           NULL /* class closure */,
                           NULL /* accumulator */,
                           NULL /* accu_data */,
                           g_cclosure_marshal_VOID__VOID,
                           G_TYPE_NONE /* return_type */,
                           0     /* n_params */,
                           NULL  /* param_types */);
        iface->sid_playing_signal_id = 
            g_signal_newv ("sid-playing",
                           G_TYPE_FROM_INTERFACE (iface),
                           G_SIGNAL_RUN_LAST | G_SIGNAL_NO_RECURSE | 
                           G_SIGNAL_NO_HOOKS,
                           NULL /* class closure */,
                           NULL /* accumulator */,
                           NULL /* accu_data */,
                           g_cclosure_marshal_VOID__VOID,
                           G_TYPE_NONE /* return_type */,
                           0     /* n_params */,
                           NULL  /* param_types */);
        iface->video_playing_signal_id = 
            g_signal_newv ("video-playing",
                           G_TYPE_FROM_INTERFACE (iface),
                           G_SIGNAL_RUN_LAST | G_SIGNAL_NO_RECURSE | 
                           G_SIGNAL_NO_HOOKS,
                           NULL /* class closure */,
                           NULL /* accumulator */,
                           NULL /* accu_data */,
                           g_cclosure_marshal_VOID__VOID,
                           G_TYPE_NONE /* return_type */,
                           0     /* n_params */,
                           NULL  /* param_types */);
        /* Is this is not used ever ??*/
        iface->state_changed_signal_id = 
            g_signal_newv ("state-changed",
                           G_TYPE_FROM_INTERFACE (iface),
                           G_SIGNAL_RUN_LAST | G_SIGNAL_NO_RECURSE | 
                           G_SIGNAL_NO_HOOKS,
                           NULL /* class closure */,
                           NULL /* accumulator */,
                           NULL /* accu_data */,
                           g_cclosure_marshal_VOID__VOID,
                           G_TYPE_NONE /* return_type */,
                           0     /* n_params */,
                           NULL  /* param_types */);
        iface->type_unknown_signal_id = 
            g_signal_newv ("type-unknown",
                           G_TYPE_FROM_INTERFACE (iface),
                           G_SIGNAL_RUN_LAST | G_SIGNAL_NO_RECURSE | 
                           G_SIGNAL_NO_HOOKS,
                           NULL /* class closure */,
                           NULL /* accumulator */,
                           NULL /* accu_data */,
                           g_cclosure_marshal_VOID__VOID,
                           G_TYPE_NONE /* return_type */,
                           0     /* n_params */,
                           NULL  /* param_types */);
        iface->position_signal_id = 
            g_signal_newv ("stream-pos",
                           G_TYPE_FROM_INTERFACE (iface),
                           G_SIGNAL_RUN_LAST | G_SIGNAL_NO_RECURSE | 
                           G_SIGNAL_NO_HOOKS,
                           NULL /* class closure */,
                           NULL /* accumulator */,
                           NULL /* accu_data */,
                           g_cclosure_marshal_VOID__VOID,
                           G_TYPE_NONE /* return_type */,
                           0     /* n_params */,
                           NULL  /* param_types */);
        iface->length_signal_id = 
            g_signal_newv ("stream-len",
                           G_TYPE_FROM_INTERFACE (iface),
                           G_SIGNAL_RUN_LAST | G_SIGNAL_NO_RECURSE | 
                           G_SIGNAL_NO_HOOKS,
                           NULL /* class closure */,
                           NULL /* accumulator */,
                           NULL /* accu_data */,
                           g_cclosure_marshal_VOID__VOID,
                           G_TYPE_NONE /* return_type */,
                           0     /* n_params */,
                           NULL  /* param_types */);
        iface->tag_found_signal_id = 
            g_signal_newv ("tag-found",
                           G_TYPE_FROM_INTERFACE (iface),
                           G_SIGNAL_RUN_LAST | G_SIGNAL_NO_RECURSE | 
                           G_SIGNAL_NO_HOOKS,
                           NULL /* class closure */,
                           NULL /* accumulator */,
                           NULL /* accu_data */,
                           g_cclosure_marshal_VOID__VOID,
                           G_TYPE_NONE /* return_type */,
                           0     /* n_params */,
                           NULL  /* param_types */);

        pspec = g_param_spec_uint ("state",
                                   "Audio state",
                                   "Set/Get audio state. (only GST_AUDIO_PLAYING is supported )",
                                   0  /* minimum value */,
                                   AUDIO_STATE_LAST /* maximum value */,
                                   0  /* default value */,
                                   G_PARAM_READABLE);
        g_object_interface_install_property (iface, pspec);
        pspec = g_param_spec_string ("mime-type",
                                     "mime-type",
                                     "Set/Get mime-type",
                                     "mp3" /* default value */,
                                     G_PARAM_READWRITE);
        g_object_interface_install_property (iface, pspec);
        pspec = g_param_spec_string ("device",
                                     "Audio device",
                                     "Set/Get audio device",
                                     "default" /* default value */,
                                     G_PARAM_READWRITE);
        g_object_interface_install_property (iface, pspec);
        pspec = g_param_spec_string ("sink",
                                     "Audio interface",
                                     "Set/Get audio interface",
                                     "alsasink" /* default value */,
                                     G_PARAM_READWRITE);
        g_object_interface_install_property (iface, pspec);
        pspec = g_param_spec_string ("uri",
                                     "URI to play",
                                     "Set/Get uri to play",
                                     "" /* default value */,
                                     G_PARAM_READWRITE);
        g_object_interface_install_property (iface, pspec);
        pspec = g_param_spec_double ("volume",
                                     "Sets volume",
                                     "Set/Get audio volume",
                                     0.0, 1.0, 0.9,
                                     G_PARAM_READWRITE);
        g_object_interface_install_property (iface, pspec);
        pspec = g_param_spec_boolean ("mute",
                                      "Sets mute",
                                      "Set/Get audio mute",
                                      FALSE,
                                      G_PARAM_READWRITE);
        g_object_interface_install_property (iface, pspec);
        pspec = g_param_spec_string   ("iradio-name",
                                       "Get radio name",
                                       "Get internet radio name",
                                       "",
                                       G_PARAM_READABLE);
        g_object_interface_install_property (iface, pspec);
        pspec = g_param_spec_uint ("stream-position",
                                   "Get position",
                                   "Get stream position ms",
                                   0  /* minimum value */,
                                   G_MAXUINT /* maximum value */,
                                   0  /* default value */,
                                   G_PARAM_READABLE);
        g_object_interface_install_property (iface, pspec);
        pspec = g_param_spec_uint ("stream-length",
                                   "Get stream length",
                                   "Get stream length in ms",
                                   0  /* minimum value */,
                                   G_MAXUINT /* maximum value */,
                                   0  /* default value */,
                                   G_PARAM_READABLE);
        g_object_interface_install_property (iface, pspec);


        pspec = g_param_spec_uint ("sid-time", 
                                  "sid time", 
                                  "Time to play SID (ms)", 
                                  0, G_MAXUINT, 0, 
                                  G_PARAM_READWRITE);
        g_object_interface_install_property (iface, pspec);

        pspec = g_param_spec_int ("sid-tune", 
                                  "sid tune", 
                                  "Selected SID tune", 
                                  0, 100, 0, 
                                  G_PARAM_READWRITE);
        g_object_interface_install_property (iface, pspec);

        pspec = g_param_spec_int ("sid-clock", 
                                  "sid clock", 
                                  "Selected SID clock", 
                                  1, 2, 1, 
                                  G_PARAM_READWRITE);
        g_object_interface_install_property (iface, pspec);

        pspec = g_param_spec_int ("sid-memory", 
                                  "sid memory", 
                                  "Selected SID memorybank",
                                  32, 34, 32, 
                                  G_PARAM_READWRITE);
        g_object_interface_install_property (iface, pspec);

        pspec = g_param_spec_boolean ("sid-filter", 
                                      "SID filter", 
                                      "Use of SID filter", 
                                      FALSE, 
                                      G_PARAM_READWRITE);
        g_object_interface_install_property (iface, pspec);

        pspec = g_param_spec_boolean ("sid-measured-volume", 
                                      "SID measured volume", 
                                      "Use of SID measured volume", 
                                      FALSE, G_PARAM_READWRITE);
        g_object_interface_install_property (iface, pspec);

        pspec = g_param_spec_boolean ("sid-mos8580", 
                                      "SID mos8580", 
                                      "Use of SID mos8580", 
                                      FALSE, 
                                      G_PARAM_READWRITE);
        g_object_interface_install_property (iface, pspec);

        pspec = g_param_spec_boolean ("sid-force-speed", 
                                      "SID mforce speed", 
                                      "Use of SID force speed", 
                                      FALSE, 
                                      G_PARAM_READWRITE);
        g_object_interface_install_property (iface, pspec);

        pspec = g_param_spec_ulong  ("xid",
                                     "Sets window xid",
                                     "Set/Get window xid where show video",
                                     0,
                                     G_MAXULONG,
                                     0,
                                     G_PARAM_READWRITE);
        g_object_interface_install_property (iface, pspec);

        pspec = g_param_spec_pointer ("tags",
                                      "Tags",
                                      "Get tags of the media",
                                      G_PARAM_READABLE);
        g_object_interface_install_property (iface, pspec);

        initialized = TRUE;
    }
}



GType kilikali_audio_get_type (void)
{
    static GType type = 0;
    if (type == 0) {
        static const GTypeInfo info = {
            sizeof (KilikaliAudioInterface),
            NULL,   /* base_init */
            NULL,   /* base_finalize */
            ( GClassInitFunc )kilikali_audio_interface_init,   /* class_init */
            NULL,   /* class_finalize */
            NULL,   /* class_data */
            0,
            0,      /* n_preallocs */
            NULL    /* instance_init */
        };
        type = g_type_register_static (G_TYPE_INTERFACE,
                                       "KilikaliAudio",
                                       &info, 0);
        g_type_interface_add_prerequisite (type, G_TYPE_OBJECT);
    }
    return type;
}



gboolean 
kilikali_audio_init (KilikaliAudio *self)
{
    return KILIKALI_AUDIO_GET_IFACE (self)->init (self);
}



void 
kilikali_audio_deinit (KilikaliAudio *self)
{
    KILIKALI_AUDIO_GET_IFACE (self)->deinit (self);
}



void 
kilikali_audio_play (KilikaliAudio *self)
{
    KILIKALI_AUDIO_GET_IFACE (self)->play (self);
}



void 
kilikali_audio_stop (KilikaliAudio *self)
{
    KILIKALI_AUDIO_GET_IFACE (self)->stop (self);
}



void 
kilikali_audio_pause (KilikaliAudio *self)
{
    KILIKALI_AUDIO_GET_IFACE (self)->pause (self);
}



void 
kilikali_audio_absolute (KilikaliAudio *self, gulong time)
{
    KILIKALI_AUDIO_GET_IFACE (self)->absolute (self, time);
}



gboolean 
kilikali_audio_is_supported (KilikaliAudio *self, const gchar *uri)
{
    return KILIKALI_AUDIO_GET_IFACE (self)->is_supported (self, uri);
}



/* Emacs indentatation information
 * Local Variables:
 * c-file-style:"stroustrup"
 * c-basic-offset:4
 * indent-tabs-mode:nil
 * End:
 */
