/*
 * * Copyright (C) 2007 Joni Valtanen <jvaltane@kapsi.fi>
 *                    Tuomas Kulve <tuomas@kulve.fi>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 * USA.
 */

#ifndef KILIKALI_AUDIO_GST_H_
#define KILIKALI_AUDIO_GST_H_

#include <gst/gst.h>
#include <glib-object.h>

#include "kilikali-audio.h"



G_BEGIN_DECLS

#define KILIKALI_TYPE_AUDIO_GST     (kilikali_audio_gst_get_type ())
#define KILIKALI_AUDIO_GST(obj)     (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
                                    KILIKALI_TYPE_AUDIO_GST, KilikaliAudioGst))
#define KILIKALI_IS_AUDIO_GST(obj)  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
                                    KILIKALI_TYPE_AUDIO_GST))
#define KILIKALI_AUDIO_GST_CLASS(klass)	  (G_TYPE_CHECK_CLASS_CAST ((klass), \
                               KILIKALI_TYPE_AUDIO_GST, KilikaliAudioGstClass))
#define KILIKALI_IS_AUDIO_GST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), \
                                           KILIKALI_TYPE_AUDIO_GST))
#define KILIKALI_AUDIO_GST_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), \
                               KILIKALI_TYPE_AUDIO_GST, KilikaliAudioGstClass))

typedef struct _KilikaliAudioGst KilikaliAudioGst;
typedef struct _KilikaliAudioGstClass KilikaliAudioGstClass;
typedef struct _KilikaliAudioGstPrivate KilikaliAudioGstPrivate;

struct _KilikaliAudioGstClass
{
    GObjectClass parent;
};

struct _KilikaliAudioGst
{
    GObject parent;

    KilikaliAudioGstPrivate *priv;
    
    GstElement *avbin;
};

KilikaliAudioGst *kilikali_audio_gst_new (void);
GType  kilikali_audio_gst_get_type (void);

G_END_DECLS

#endif /* _KILIKALI_AUDIO_GST_H_ */



/* Emacs indentatation information
 * Local Variables:
 * c-file-style:"stroustrup"
 * c-basic-offset:4
 * indent-tabs-mode:nil
 * End:
 */
