#!/usr/bin/env python

from distutils.core import setup
import os

keepnote = []
for item in os.listdir('keepnote'):
   keepnote.append('keepnote/' + item)
   
compat = []
for item in os.listdir('compat/'):
   compat.append('compat/' + item)
   
gui = []
for item in os.listdir('gui/'):
   gui.append('gui/' + item)
   
images = []
for item in os.listdir('images/'):
   images.append('images/' + item)
   
node_icons = []
for item in os.listdir('node_icons/'):
   node_icons.append('node_icons/' + item)
   
rc = []
for item in os.listdir('rc/'):
   rc.append('rc/' + item)
   
richtext = []
for item in os.listdir('richtext/'):
   richtext.append('richtext/' + item)

setup(name='keepnote',
   version='5.2',
   scripts=['bin/keepnote'],
   data_files = [
      ('/usr/share/icons/hicolor/26x26/hildon/',['desktop/26x26/keepnote.png']),
      ('/usr/share/icons/hicolor/40x40/hildon/',['desktop/40x40/keepnote.png']),
      ('/usr/share/icons/hicolor/scalable/hildon/',['desktop/scalable/keepnote.png']),
      ('/usr/share/applications/hildon/',['desktop/keepnote.desktop']),
      ('/usr/lib/python2.5/site-packages/keepnote/', keepnote),
      ('/usr/lib/python2.5/site-packages/keepnote/compat/', compat),
      ('/usr/lib/python2.5/site-packages/keepnote/extensions/backup_tar/',['extensions/backup_tar/__init__.py']),
      ('/usr/lib/python2.5/site-packages/keepnote/gui/', gui),
      ('/usr/lib/python2.5/site-packages/keepnote/images/', images),
      ('/usr/lib/python2.5/site-packages/keepnote/images/node_icons/', node_icons),
      ('/usr/lib/python2.5/site-packages/keepnote/rc/', rc),
      ('/usr/lib/python2.5/site-packages/keepnote/gui/richtext/', richtext)
      ]
      )