#ifndef SELECTOR_H
#define SELECTOR_H

/*
  Kandis - A tea steepming timer.
  Copyright (C) 2007  Tim Teulings

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <Lum/Model/Action.h>
#include <Lum/Model/Integer.h>
#include <Lum/Model/Selection.h>
#include <Lum/Model/String.h>
#include <Lum/Model/Table.h>

#include <Lum/Dialog.h>

class Selector : public Lum::Dialog
{
private:
  Lum::Model::StringRef              value;
  Lum::Model::IntRef                 minutes;
  Lum::Model::IntRef                 seconds;
  Lum::Model::ListTableRef           list;
  Lum::Model::SingleLineSelectionRef selection;

  Lum::Model::ActionRef              addAction;
  Lum::Model::ActionRef              updateAction;
  Lum::Model::ActionRef              removeAction;
  Lum::Model::ActionRef              okAction;

private:
  std::wstring GetTimeString(size_t minutes, size_t seconds) const;

public:
  Selector(Lum::Model::Int* minutes, Lum::Model::Int *seconds);

  void PreInit();

  void Resync(Lum::Base::Model *model, const Lum::Base::ResyncMsg& msg);
};

#endif
