#!/usr/bin/env python2.5
#
# This file is part of isearch-edit, a tool to create and edit
# files for the maemo internet search applet
#
# (c) 2007 Thomas Schmidt <tschmidt@debian.org>
#
# This code is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 3
# of the License, or (at your option) any later version.
#
# This code is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with isearch-edit. If not, see <http://www.gnu.org/licenses/>.
#

class MisParser():
  import xml.dom.minidom
  import xml.dom.ext

  from xml.dom.minidom import Node
  from xml.dom.minidom import getDOMImplementation

  def __init__(self, filename):
    self.filename = filename

    self.misname      = None
    self.misaction    = None
    self.misicon      = None
    self.misuserinput = None
  
    self.misinputs    = []  
    
    if self.filename != None:
      # parse existing mis file
      # TODO: check if file really exists, else raise exception
      self.mis = self.xml.dom.minidom.parse(self.filename)
      for node in self.mis.getElementsByTagName("search"):
        self.misname      = node.getAttribute("name")
        self.misicon      = node.getAttribute("icon")
        self.misaction    = node.getAttribute("action")
        self.misuserinput = node.getAttribute("user-input")
        
        L = node.getElementsByTagName("input")
        for node2 in L:
          inputname   = node2.getAttribute("name")
          inputvalue  = node2.getAttribute("value")
          inputtuple  = (inputname, inputvalue)
          self.misinputs.append(inputtuple)
    
    else:
      # create new mis file
      self.impl = self.xml.dom.minidom.getDOMImplementation()
      self.mis  = self.impl.createDocument(None, "search", None)
    
  def set_filename(self, filename):
    self.filename = filename

  def get_filename(self):
    return self.filename

  def set_name(self, misname):
    self.misname = misname
  
  def get_name(self):
    return self.misname
  
  def set_icon(self, misicon):
    self.misicon = misicon
  
  def get_icon(self):
    return self.misicon
  
  def set_action(self, misaction):
    self.misaction = misaction
  
  def get_action(self):
    return self.misaction
  
  def set_userinput(self, misuserinput):
    self.misuserinput = misuserinput

  def get_userinput(self):
    return self.misuserinput

  def set_inputs(self, misinputs):
      self.misinputs = misinputs
  
  def get_inputs(self):
    return self.misinputs
  
  def prepare_mis(self):
    top_element = self.mis.documentElement
    if self.misname != None:
      top_element.setAttribute("name", self.misname)
    if self.misicon != None:
      top_element.setAttribute("icon", self.misicon)
    if self.misaction != None:
      top_element.setAttribute("action", self.misaction)
    if self.misuserinput != None:
      top_element.setAttribute("user-input", self.misuserinput)
  
    # remove allready existing input elements
    for node in self.mis.getElementsByTagName("search"):
      L = node.getElementsByTagName("input")
      for node2 in L:
        node.removeChild(node2)

    for input_element in self.misinputs:
      inputname   = input_element[0]
      inputvalue  = input_element[1]
      child_element = self.mis.createElement("input")
      child_element.setAttribute("name", inputname)
      child_element.setAttribute("value", inputvalue)
      top_element.appendChild(child_element)
  
  def show_mis(self):
    self.prepare_mis()
    self.xml.dom.ext.PrettyPrint(self.mis)

  def write_mis(self):
    # TODO: raise exeption in case of errors
    if self.filename != None:
      self.prepare_mis()
      file_object = open(self.filename, "w")
      self.xml.dom.ext.PrettyPrint(self.mis, file_object)
      file_object.close()

  def MisToUrl(self):
    url =   self.misaction
    url +=  '?' + self.misuserinput + '=%s'

    for input in self.misinputs:
      inputname   = input[0]
      inputvalue  = input[1]
      url += "&" + inputname + "=" + inputvalue
    
    return url

  def UrlToMis(self, url, name, icon):
    inputs = []
    
    temp = url.split('?')
    action = temp[0]
   
    arguments = temp[1]
    parameters = arguments.split('&')

    for input in parameters:
      input_tmp   = input.split('=')
      inputname   = input_tmp[0]
      inputvalue  = input_tmp[1]
      
      if inputvalue.find('%s') != -1:
        self.set_userinput(inputname)
      else:
        inputtuple = (inputname, inputvalue)
        inputs.append(inputtuple)
    
    self.set_action(action)
    self.set_inputs(inputs)
    self.set_name(name)
    self.set_icon(icon)

    return self

# vim: set expandtab tabstop=2 shiftwidth=2 autoindent smartindent foldmethod=indent:
