/*
* IceBreaker
* Copyright (c) 2000-2001 Matthew Miller <mattdm@mattdm.org> 
*   http://www.mattdm.org/
*
* This program is free software; you can redistribute it and/or modify it
* under the terms of the GNU General Public License as published by the Free
* Software Foundation; either version 2 of the License, or (at your option)
* any later version.
*
* This program is distributed in the hope that it will be useful, but
* WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
* or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
* for more details.
*
* You should have received a copy of the GNU General Public License along
* with this program; if not, write to the Free Software Foundation, Inc., 59
* Temple Place, Suite 330, Boston, MA 02111-1307 USA
*
*/

#include <SDL/SDL.h>

#include "icebreaker.h"
#include "text.h"
#include "globals.h"
#include "hiscore.h"
#include "laundry.h"
#include "status.h"


void updatestatuslives(int lives)
{
	//FIX == shouldn't need to recalc color every time.

	SDL_Rect tmprect;
	char tmptext[30]; // should be plenty big.
	
	//lives=99; //debug
	
#ifdef MAEMO	
	tmprect.h=CHARHEIGHT*4; tmprect.w=LIVESW;
	tmprect.x=LIVESX; tmprect.y=LIVESY;
#else
	tmprect.h=CHARHEIGHT*2; tmprect.w=LIVESW;
	tmprect.x=LIVESX; tmprect.y=STATUSY;
#endif	
	SDL_FillRect(screen,&tmprect,SDL_MapRGB(screen->format,  0x00, 0x40, 0x80));
	snprintf(tmptext,30,"LIVES: %d",lives);
	
#ifdef MAEMO	
	puttext(LIVESX,LIVESY,4,SDL_MapRGB(screen->format,  0xFF, 0xFF, 0xFF),tmptext);
#else
	puttext(LIVESX,STATUSY,2,SDL_MapRGB(screen->format,  0xFF, 0xFF, 0xFF),tmptext);
#endif	
	
	soil(tmprect);

}

void updatestatuscleared(int cleared)
{
	//FIX == shouldn't need to recalc color every time.

	SDL_Rect tmprect;
	char tmptext[30]; // should be plenty big.
	
	//cleared=99; // debug
	
#ifdef MAEMO
	tmprect.h=CHARHEIGHT*4; tmprect.w=CLEAREDW;
	tmprect.x=CLEAREDX; tmprect.y=STATUSY;
#else	
	tmprect.h=CHARHEIGHT*2; tmprect.w=CLEAREDW;
	tmprect.x=CLEAREDX; tmprect.y=STATUSY;
#endif	
	SDL_FillRect(screen,&tmprect,SDL_MapRGB(screen->format,  0x00, 0x40, 0x80));
	snprintf(tmptext,30, "CLEARED: %d%%",cleared);
#ifdef MAEMO
	puttext(CLEAREDX,STATUSY,4,SDL_MapRGB(screen->format,  0xFF, 0xFF, 0xFF),tmptext);
#else
	puttext(CLEAREDX,STATUSY,2,SDL_MapRGB(screen->format,  0xFF, 0xFF, 0xFF),tmptext);
#endif	
	soil(tmprect);

}

void updatestatusscore(long score)
{
	//FIX == shouldn't need to recalc color every time.

	SDL_Rect tmprect;
	char tmptext[30]; // should be plenty big.
	
	//score=99999; // debug
#ifdef MAEMO	
	tmprect.h=CHARHEIGHT*4; tmprect.w=SCOREW;
	tmprect.x=SCOREX; tmprect.y=STATUSY;
#else	
	tmprect.h=CHARHEIGHT*2; tmprect.w=SCOREW;
	tmprect.x=SCOREX; tmprect.y=STATUSY;
#endif	
	SDL_FillRect(screen,&tmprect,SDL_MapRGB(screen->format,  0x00, 0x40, 0x80));
	snprintf(tmptext,30, "SCORE: %ld",score);
#ifdef MAEMO	
	puttext(SCOREX,STATUSY,4,SDL_MapRGB(screen->format,  0xFF, 0xFF, 0xFF),tmptext);
#else	
	puttext(SCOREX,STATUSY,2,SDL_MapRGB(screen->format,  0xFF, 0xFF, 0xFF),tmptext);
#endif
	soil(tmprect);
}



extern void updatehiscorebox()
{ // FIX -- this might belong in hiscore.c, but maybe not
#ifndef MAEMO	
	SDL_Rect tmprect;
	
	char tmptext[40]; // should be plenty big.
	
	tmprect.x=LIVESX; tmprect.y=BOTTOMSTATUSY;
	tmprect.h=CHARHEIGHT*3;; tmprect.w=WIDTH-(CHARWIDTH*2*4)-MARGINRIGHT-4-LIVESX-2;
	
	SDL_FillRect(screen,&tmprect,SDL_MapRGB(screen->format,  0x00, 0x40, 0x80));
	
	snprintf(tmptext,40,"HIGH SCORE: %ld (%s)",hiscoreval[0],hiscorename[0]);
	puttext(tmprect.x,tmprect.y+3,2,SDL_MapRGB(screen->format,  0xFF, 0xFF, 0xFF),tmptext);	
	
	soil(tmprect);
#endif
}
