/*
* IceBreaker
* Copyright (c) 2000-2001 Matthew Miller <mattdm@mattdm.org>
*   http://www.mattdm.org/
*
* This program is free software; you can redistribute it and/or modify it
* under the terms of the GNU General Public License as published by the Free
* Software Foundation; either version 2 of the License, or (at your option)
* any later version.
*
* This program is distributed in the hope that it will be useful, but
* WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
* or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
* for more details.
*
* You should have received a copy of the GNU General Public License along
* with this program; if not, write to the Free Software Foundation, Inc., 59
* Temple Place, Suite 330, Boston, MA 02111-1307 USA
*
*/

#include <SDL/SDL.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "icebreaker.h"
#include "cursor.h"
#include "penguin.h"
#include "line.h"
#include "grid.h"
#include "laundry.h"
#include "sound.h"
#include "globals.h"
#include "level.h"
#include "status.h"
#include "text.h"
#include "dialog.h"
#include "options.h"


Line line1;
Line line2;

#ifdef MAEMO

SDL_Surface * backgroundimage;
Penguin flock[MAXPENGUINS];
int penguincount;
long oldscore;
int clear;
int lives;
void statesave(int *level, ScoreSheet *levelscore) ;
int loadstatesaved(int *actuallevel, ScoreSheet *levelscore) ;
#if HGW_FUNC
	#include <hgw/hgw.h>
	extern HgwContext *hgw_context;
#endif
#endif

//static void setuplevel(void);

void setuplevel(int load)
{
	int x,y;
	int c;
	SDL_Rect tmprect, tmprect2;

	setcursor(CURSORARROW);
	SDL_FillRect(screen,NULL,SDL_MapRGB(screen->format, 0x00, 0x40, 0x80));
#ifdef MAEMO	
	tmprect.x=BORDERLEFT; tmprect.y=0;
	tmprect.w=0; tmprect.h=0;
	
	backgroundimage = SDL_LoadBMP(IMAGEPREFIX "/" BACKGROUNDBMPFILE);
	SDL_BlitSurface(backgroundimage, NULL, screen, &tmprect);
#endif
	tmprect.x=BORDERLEFT; tmprect.y=BORDERTOP;
	tmprect.w=PLAYWIDTH; tmprect.h=PLAYHEIGHT;
//	SDL_FillRect(screen,&tmprect,SDL_MapRGB(screen->format, 0xC0, 0xC0, 0xC0));

	//tmprect.w=BLOCKWIDTH-1; tmprect.h=BLOCKHEIGHT-1;
	//for (tmprect.x=BORDERLEFT;tmprect.x<BORDERRIGHT;tmprect.x+=BLOCKWIDTH)
	//	for (tmprect.y=BORDERTOP;tmprect.y<BORDERBOTTOM;tmprect.y+=BLOCKHEIGHT)
	//		SDL_FillRect(screen,&tmprect,SDL_MapRGB(screen->format, 0xFF, 0xFF, 0xFF));

	if (!load) for (x=0;x<WIDTH;x++)
		for (y=0;y<HEIGHT;y++)
		{
			if (x<BORDERLEFT || x>=BORDERRIGHT || y <BORDERTOP || y>=BORDERBOTTOM) 	
				grid[x][y]='X';
			else
				grid[x][y]=' ';
		}

	tmprect.w=BLOCKWIDTH-1; tmprect.h=BLOCKHEIGHT-1;
	for (tmprect.x=BORDERLEFT;tmprect.x<BORDERRIGHT;tmprect.x+=BLOCKWIDTH)
		for (tmprect.y=BORDERTOP;tmprect.y<BORDERBOTTOM;tmprect.y+=BLOCKHEIGHT)
			{
			
				if (grid[tmprect.x][tmprect.y] == ' ' || grid[tmprect.x][tmprect.y] == ' ') {
					c = (random() % 32)+224;
					memcpy(&tmprect2, &tmprect, sizeof(SDL_Rect));
//					tmprect2.x--; tmprect2.y--;
					tmprect2.w++; tmprect2.h++;					
					SDL_FillRect(screen,&tmprect2,SDL_MapRGB(screen->format, 0xC0, 0xC0, 0xC0));
					SDL_FillRect(screen,&tmprect,SDL_MapRGB(screen->format, c, c, c));
				}
			}
	SDL_BlitSurface(screen, NULL, screensave, NULL);


	
	SDL_UpdateRect(screen,0,0,0,0);

	

}



LevelExitType playlevel(int * level, long score, ScoreSheet * levelscore)
{
//	level = level;
	#ifndef MAEMO
	int penguincount=level+1;
	int lives=level+1;
	int clear=0;
	#endif

	LevelExitType returncode=ERROR;
	int i,x,y,xdif,ydif, load;

	SDL_Rect difficultybuttonrect;
	int 	 difficultybuttonglow=false;
	int 	 difficultybuttonpressed=false;

	SDL_Rect newgamebuttonrect;
	int 	 newgamebuttonglow=false;
	int 	 newgamebuttonpressed=false;
	
	SDL_Rect quitbuttonrect;
	int 	 quitbuttonglow=false;
	int 	 quitbuttonpressed=false;
	
	SDL_Rect helpbuttonrect;
	int      helpbuttonglow=false;
	int 	 helpbuttonpressed=false;
		
	
	int paused=false;

	int linedoneflag=false;
	LineType linetype;
	float scoremod=1;
	float bonusmod=1;
	
	int tick=0;
	int timepenalty=0;
	int timepenaltyinterval=0;
	
#ifdef MAEMO	
	int dohelpflag = false;
	int doquitflag = false;
	int donewgameflag = false;
	int dodifficultyflag = false;
#else
	int domenuflag = false;
#endif		
	int done = false;
	
	#ifndef MAEMO
	// FIX -- this is a good candidate for dynamic memory allocation...
	//Penguin flock[penguincount];
	Penguin flock[MAXPENGUINS];
	#endif
	SDL_Event event;

	switch(options.difficulty)
	{
		case NORMAL:
			scoremod=(*level+1)/2.0;
			bonusmod=(*level+1)/2.0;
			timepenaltyinterval=100;
		break;
		case EASY:
			scoremod=(*level+1)/5.0;
			bonusmod=(*level+1)/7.0;
			timepenaltyinterval=200;
		break;
		case HARD:
			scoremod=(*level+1)/1.75;
			bonusmod=(*level+1)/1.5;
			timepenaltyinterval=75;
		break;
		default:
			fprintf(stderr,"Unknown difficulty -- that can't happen!\n");
		break;
	}

	levelscore->basescore=0;
	levelscore->clearbonus=0;
	levelscore->lifebonus=0;
	oldscore = score;
#ifdef MAEMO
	clear=0;
	lives=*level+1;
	load = loadstatesaved(level, levelscore);
	remove("/tmp/.icebreaker-saved");
//	penguincount=level+1;
#endif
	setuplevel(load);
	
	setcursor(CURSORVERTICAL); linetype=VERTICAL; 

/*	printf("===========================================================\n"
	       "Starting level %d.\n"
	       "Lives: %d\n",
	       level,lives);
*/	       

#ifdef MAEMO
	newgamebuttonrect.x=583;//WIDTH-(CHARWIDTH*2*4)-MARGINRIGHT-4;
	newgamebuttonrect.y=90;//BOTTOMSTATUSY;
	newgamebuttonrect.w=CHARWIDTH*2*7+3;
	newgamebuttonrect.h=CHARHEIGHT*2+3;
	puttext(newgamebuttonrect.x+3,newgamebuttonrect.y+3,2,SDL_MapRGB(screen->format, 0xFF, 0xFF, 0xFF),"NEW GAME");
	soil(newgamebuttonrect);	

	helpbuttonrect.x=583;//WIDTH-(CHARWIDTH*2*4)-MARGINRIGHT-4;
	helpbuttonrect.y=130;//BOTTOMSTATUSY;
	helpbuttonrect.w=CHARWIDTH*2*4+3;
	helpbuttonrect.h=CHARHEIGHT*2+3;
	puttext(helpbuttonrect.x+3,helpbuttonrect.y+3,2,SDL_MapRGB(screen->format, 0xFF, 0xFF, 0xFF),"HELP");
	soil(helpbuttonrect);	
	
	difficultybuttonrect.x=583;//WIDTH-(CHARWIDTH*2*4)-MARGINRIGHT-4;
	difficultybuttonrect.y=170;//BOTTOMSTATUSY;
	difficultybuttonrect.w=CHARWIDTH*2*16+3;
	difficultybuttonrect.h=CHARHEIGHT*2+3;
	
	switch(options.difficulty)
	{
		case NORMAL:
			SDL_FillRect(screen,&difficultybuttonrect,SDL_MapRGB(screen->format,  0x00, 0x40, 0x80));
			puttext(difficultybuttonrect.x+3,difficultybuttonrect.y+3,2,SDL_MapRGB(screen->format, 0xFF, 0xFF, 0xFF),"DIFFICULTY  NORMAL");
		break;
		case EASY:
			SDL_FillRect(screen,&difficultybuttonrect,SDL_MapRGB(screen->format,  0x00, 0x40, 0x80));
			puttext(difficultybuttonrect.x+3,difficultybuttonrect.y+3,2,SDL_MapRGB(screen->format, 0xFF, 0xFF, 0xFF),"DIFFICULTY  EASY");
		break;
		case HARD:
			SDL_FillRect(screen,&difficultybuttonrect,SDL_MapRGB(screen->format,  0x00, 0x40, 0x80));
			puttext(difficultybuttonrect.x+3,difficultybuttonrect.y+3,2,SDL_MapRGB(screen->format, 0xFF, 0xFF, 0xFF),"DIFFICULTY  HARD");
		break;
		default:
			fprintf(stderr,"Unknown difficulty -- that can't happen!\n");
		break;
	}

	soil(difficultybuttonrect);	
	
	quitbuttonrect.x=583;//WIDTH-(CHARWIDTH*2*4)-MARGINRIGHT-4;
	quitbuttonrect.y=210;//BOTTOMSTATUSY;
	quitbuttonrect.w=CHARWIDTH*2*4+3;
	quitbuttonrect.h=CHARHEIGHT*2+3;
	puttext(quitbuttonrect.x+3,quitbuttonrect.y+3,2,SDL_MapRGB(screen->format, 0xFF, 0xFF, 0xFF),"QUIT");
	soil(quitbuttonrect);	
#else
	menubuttonrect.x=WIDTH-(CHARWIDTH*2*4)-MARGINRIGHT-4;
	menubuttonrect.y=BOTTOMSTATUSY;
	menubuttonrect.w=CHARWIDTH*2*4+3;
	menubuttonrect.h=CHARHEIGHT*2+3;
	puttext(menubuttonrect.x+3,menubuttonrect.y+3,2,SDL_MapRGB(screen->format, 0xFF, 0xFF, 0xFF),"MENU");
	soil(menubuttonrect);	
#endif
		
	line1=createline('1',0x00, 0x00, 0x00);
	//line1=createline('1',0x00, 0x40, 0x80);
	line2=createline('2',0xC0, 0x00, 0x40);

	if (!load) {
		penguincount=*level+1;		
		for (i=0;i<penguincount;i++) flock[i] = createpenguin();
	}
	
	updatestatuslives(lives);
	updatestatuscleared(clear);
#ifndef MAEMO	
	updatestatusscore(oldscore);
#else	
	updatestatusscore(oldscore+levelscore->basescore);
#endif	
	updatehiscorebox();	
	//clean();


	do 
	{

		// FIX -- this is way too messy. time to split it up into
		// neat little functions or something. Especially the menubutton stuff.
		while (SDL_PollEvent(&event))
		{
			if (event.type == SDL_QUIT || (event.type == SDL_KEYDOWN && ((&event.key.keysym)->sym == SDLK_ESCAPE)))
			{
				//lives=0; // is this the right way?
				done = true;
				statesave(level, levelscore);
				return PAUSE;
			}
#ifdef MAEMO
			else if (event.type == SDL_KEYDOWN && (((&event.key.keysym)->sym == SDLK_F4) 
							      || ((&event.key.keysym)->sym == SDLK_F5)
							      || ((&event.key.keysym)->sym == SDLK_F6)))
			{
				statesave(level, levelscore);
				return PAUSE;
			}						
			else if (event.type == SDL_KEYDOWN)
			{
				switch (linetype)
				{
					case VERTICAL:
						linetype=HORIZONTAL;
						setcursor(CURSORHORIZONTAL); 
					break;
					case HORIZONTAL:
						linetype=VERTICAL;
						setcursor(CURSORVERTICAL);
					break;
				}
			}
#endif			
			else if (event.type == SDL_MOUSEMOTION)
			{
				//if (grid[event.motion.x][event.motion.y] == ' ' || grid[event.motion.x][event.motion.y] == '*')
				if (event.motion.x>BORDERLEFT && event.motion.x<BORDERRIGHT && event.motion.y>BORDERTOP && event.motion.y<BORDERBOTTOM)	
				{
					switch (linetype)
					{
						case HORIZONTAL:
							setcursor(CURSORHORIZONTAL);
						break;
						case VERTICAL:
							setcursor(CURSORVERTICAL);
						break;
					}
					
				}			
				else  // we're somewhere outside of the playing area
				{
					setcursor(CURSORARROW);
				}
#ifndef MAEMO				
				if (event.motion.x>=menubuttonrect.x && event.motion.y>=menubuttonrect.y && event.motion.x<menubuttonrect.x+menubuttonrect.w && event.motion.y<menubuttonrect.y+menubuttonrect.h)
				{ // over the menu button
					if (!menubuttonglow)
					{
						menubuttonglow=true;
						SDL_FillRect(screen,&menubuttonrect,SDL_MapRGB(screen->format, 0xF0, 0xF0, 0xF0));
						puttext(menubuttonrect.x+3,menubuttonrect.y+3,2,SDL_MapRGB(screen->format, 0x00, 0x40, 0x80),"MENU");
					}

				}
				else 
				{
					if (menubuttonglow && !menubuttonpressed)
					{
						menubuttonglow=false;
						SDL_FillRect(screen,&menubuttonrect,SDL_MapRGB(screen->format, 0x00, 0x40, 0x80));
						puttext(menubuttonrect.x+3,menubuttonrect.y+3,2,SDL_MapRGB(screen->format, 0xFF, 0xFF, 0xFF),"MENU");
					}
				
				}
				soil(menubuttonrect);	
#else				
				if (event.motion.x>=helpbuttonrect.x && event.motion.y>=helpbuttonrect.y && event.motion.x<helpbuttonrect.x+helpbuttonrect.w && event.motion.y<helpbuttonrect.y+helpbuttonrect.h)
				{ // over the help button
					if (!helpbuttonglow)
					{
						helpbuttonglow=true;
						SDL_FillRect(screen,&helpbuttonrect,SDL_MapRGB(screen->format, 0xF0, 0xF0, 0xF0));
						puttext(helpbuttonrect.x+3,helpbuttonrect.y+3,2,SDL_MapRGB(screen->format, 0x00, 0x40, 0x80),"HELP");
					}

				}
				else 
				{
					if (helpbuttonglow && !helpbuttonpressed)
					{
						helpbuttonglow=false;
						SDL_FillRect(screen,&helpbuttonrect,SDL_MapRGB(screen->format, 0x00, 0x40, 0x80));
						puttext(helpbuttonrect.x+3,helpbuttonrect.y+3,2,SDL_MapRGB(screen->format, 0xFF, 0xFF, 0xFF),"HELP");
					}
				
				}
				soil(helpbuttonrect);	
				if (event.motion.x>=quitbuttonrect.x && event.motion.y>=quitbuttonrect.y && event.motion.x<quitbuttonrect.x+quitbuttonrect.w && event.motion.y<quitbuttonrect.y+quitbuttonrect.h)
				{ // over the menu button
					if (!quitbuttonglow)
					{
						quitbuttonglow=true;
						SDL_FillRect(screen,&quitbuttonrect,SDL_MapRGB(screen->format, 0xF0, 0xF0, 0xF0));
						puttext(quitbuttonrect.x+3,quitbuttonrect.y+3,2,SDL_MapRGB(screen->format, 0x00, 0x40, 0x80),"QUIT");
					}

				}
				else 
				{
					if (quitbuttonglow && !quitbuttonpressed)
					{
						quitbuttonglow=false;
						SDL_FillRect(screen,&quitbuttonrect,SDL_MapRGB(screen->format, 0x00, 0x40, 0x80));
						puttext(quitbuttonrect.x+3,quitbuttonrect.y+3,2,SDL_MapRGB(screen->format, 0xFF, 0xFF, 0xFF),"QUIT");
					}
				
				}
				soil(quitbuttonrect);
				if (event.motion.x>=newgamebuttonrect.x && event.motion.y>=newgamebuttonrect.y && event.motion.x<newgamebuttonrect.x+newgamebuttonrect.w && event.motion.y<newgamebuttonrect.y+newgamebuttonrect.h)
				{ // over the menu button
					if (!newgamebuttonglow)
					{
						newgamebuttonglow=true;
						SDL_FillRect(screen,&newgamebuttonrect,SDL_MapRGB(screen->format, 0xF0, 0xF0, 0xF0));
						puttext(newgamebuttonrect.x+3,newgamebuttonrect.y+3,2,SDL_MapRGB(screen->format, 0x00, 0x40, 0x80),"NEW GAME");
					}

				}
				else 
				{
					if (newgamebuttonglow && !newgamebuttonpressed)
					{
						newgamebuttonglow=false;
						SDL_FillRect(screen,&newgamebuttonrect,SDL_MapRGB(screen->format, 0x00, 0x40, 0x80));
						puttext(newgamebuttonrect.x+3,newgamebuttonrect.y+3,2,SDL_MapRGB(screen->format, 0xFF, 0xFF, 0xFF),"NEW GAME");
					}
				
				}
				soil(newgamebuttonrect);
				if (event.motion.x>=difficultybuttonrect.x && event.motion.y>=difficultybuttonrect.y && event.motion.x<difficultybuttonrect.x+difficultybuttonrect.w && event.motion.y<difficultybuttonrect.y+difficultybuttonrect.h)
				{ // over the difficulty button
					if (!difficultybuttonglow)
					{
						difficultybuttonglow=true;
						SDL_FillRect(screen,&difficultybuttonrect,SDL_MapRGB(screen->format, 0xF0, 0xF0, 0xF0));
						switch(options.difficulty)
						{
							case NORMAL:
								puttext(difficultybuttonrect.x+3,difficultybuttonrect.y+3,2,SDL_MapRGB(screen->format, 0x00, 0x40, 0x80),"DIFFICULTY  NORMAL");
							break;
							case EASY:
								puttext(difficultybuttonrect.x+3,difficultybuttonrect.y+3,2,SDL_MapRGB(screen->format, 0x00, 0x40, 0x80),"DIFFICULTY  EASY");
							break;
							case HARD:
								puttext(difficultybuttonrect.x+3,difficultybuttonrect.y+3,2,SDL_MapRGB(screen->format, 0x00, 0x40, 0x80),"DIFFICULTY  HARD");
							break;
							default:
								fprintf(stderr,"Unknown difficulty -- that can't happen!\n");
							break;
						}
					}
				}
				else 
				{
					if (difficultybuttonglow && !difficultybuttonpressed)
					{
						difficultybuttonglow=false;
						SDL_FillRect(screen,&difficultybuttonrect,SDL_MapRGB(screen->format, 0x00, 0x40, 0x80));
						switch(options.difficulty)
						{
							case NORMAL:
								puttext(difficultybuttonrect.x+3,difficultybuttonrect.y+3,2,SDL_MapRGB(screen->format, 0xFF, 0xFF, 0xFF),"DIFFICULTY  NORMAL");
							break;
							case EASY:
								puttext(difficultybuttonrect.x+3,difficultybuttonrect.y+3,2,SDL_MapRGB(screen->format, 0xFF, 0xFF, 0xFF),"DIFFICULTY  EASY");
							break;
							case HARD:
								puttext(difficultybuttonrect.x+3,difficultybuttonrect.y+3,2,SDL_MapRGB(screen->format, 0xFF, 0xFF, 0xFF),"DIFFICULTY  HARD");
							break;
							default:
								fprintf(stderr,"Unknown difficulty -- that can't happen!\n");
							break;
						}
					}
				
				}
				soil(difficultybuttonrect);
			}
#endif			
			else if (event.type == SDL_MOUSEBUTTONDOWN)
			{
				if (event.button.button==1) //left
				{
					// in game area?
					if (event.button.x>BORDERLEFT && event.button.x<BORDERRIGHT && event.button.y>BORDERTOP && event.button.y<BORDERBOTTOM)
					{
						x=(((event.button.x-BORDERLEFT)/BLOCKWIDTH ) * BLOCKWIDTH )+ BORDERLEFT;
#ifdef MAEMO
				  		y=(((event.button.y-BORDERTOP-34)/BLOCKHEIGHT) * BLOCKHEIGHT) + BORDERTOP-34;
#else
				  		y=(((event.button.y-BORDERTOP)/BLOCKHEIGHT) * BLOCKHEIGHT) +BORDERTOP;
#endif			  			
						xdif=event.button.x-x; ydif=event.button.y-y;

  						if (grid[x][y] == '*' || grid[event.button.x][event.button.y] == '*') 
						{ // a little bit of grace if the player clicks directly on the penguin
							playsound(SNDOUCH);
						}
						else if (grid[x][y] == ' ')
						{

							switch (linetype)
							{
								case VERTICAL:
									if (!line1.on) (ydif<BLOCKHEIGHT/2) ? startline(&line1,UP,x,y) : startline(&line1,UP,x,y+BLOCKHEIGHT);
									if (!line2.on) (ydif<BLOCKHEIGHT/2) ? startline(&line2,DOWN,x,y) : startline(&line2,DOWN,x,y+BLOCKHEIGHT);
								break;
								case HORIZONTAL:
									if (!line1.on) (xdif<BLOCKWIDTH/2) ? startline(&line1,LEFT,x,y) : startline(&line1,LEFT,x+BLOCKWIDTH,y);
									if (!line2.on) (xdif<BLOCKWIDTH/2) ? startline(&line2,RIGHT,x,y) : startline(&line2,RIGHT,x+BLOCKWIDTH,y);
								break;
							}
  						}
					}
#ifndef MAEMO					
					else if (event.button.x>=menubuttonrect.x && event.button.y>=menubuttonrect.y && event.button.x<menubuttonrect.x+menubuttonrect.w && event.button.y<menubuttonrect.y+menubuttonrect.h)
					{
						menubuttonpressed=true;
					}
#else					
					else if (event.button.x>=helpbuttonrect.x && event.button.y>=helpbuttonrect.y && event.button.x<helpbuttonrect.x+helpbuttonrect.w && event.button.y<helpbuttonrect.y+helpbuttonrect.h)
					{
						helpbuttonpressed=true;
					}
					         
					else if (event.button.x>=quitbuttonrect.x && event.button.y>=quitbuttonrect.y && event.button.x<quitbuttonrect.x+quitbuttonrect.w && event.button.y<quitbuttonrect.y+quitbuttonrect.h)
					{
						quitbuttonpressed=true;
					}
					         
					else if (event.button.x>=newgamebuttonrect.x && event.button.y>=newgamebuttonrect.y && event.button.x<newgamebuttonrect.x+newgamebuttonrect.w && event.button.y<newgamebuttonrect.y+newgamebuttonrect.h)
					{
						newgamebuttonpressed=true;
					}
					
					else if (event.button.x>=difficultybuttonrect.x && event.button.y>=difficultybuttonrect.y && event.button.x<difficultybuttonrect.x+difficultybuttonrect.w && event.button.y<difficultybuttonrect.y+difficultybuttonrect.h)
					{
						difficultybuttonpressed=true;
					}
#endif					         
				}
				else if (event.button.button==3) // for testing!
				{
//					printwholegrid();  				
  				}
  				else //middle or right
  				{
  					switch (linetype)
					{
						case VERTICAL:
							linetype=HORIZONTAL;
							setcursor(CURSORHORIZONTAL); 
						break;
						case HORIZONTAL:
							linetype=VERTICAL;
							setcursor(CURSORVERTICAL);
						break;
					}
				}
			}
			else if (event.type == SDL_MOUSEBUTTONUP)
			{
#ifdef MAEMO
				if (quitbuttonpressed && event.button.x>=quitbuttonrect.x && event.button.y>=quitbuttonrect.y && event.button.x<quitbuttonrect.x+quitbuttonrect.w && event.button.y<quitbuttonrect.y+quitbuttonrect.h)
				{
					quitbuttonglow=true;
					
					SDL_FillRect(screen,&quitbuttonrect,SDL_MapRGB(screen->format, 0xF0, 0xF0, 0xF0));
					puttext(quitbuttonrect.x+3,quitbuttonrect.y+3,2,SDL_MapRGB(screen->format, 0x00, 0x40, 0x80),"QUIT");
					soil(quitbuttonrect);

					doquitflag=true;
				}
				else if (quitbuttonglow && quitbuttonpressed)
				{
					quitbuttonglow=false;
					SDL_FillRect(screen,&quitbuttonrect,SDL_MapRGB(screen->format, 0x00, 0x40, 0x80));
					puttext(quitbuttonrect.x+3,quitbuttonrect.y+3,2,SDL_MapRGB(screen->format, 0xFF, 0xFF, 0xFF),"QUIT");
					soil(quitbuttonrect);	
				}
				quitbuttonpressed=false;
				if (helpbuttonpressed && event.button.x>=helpbuttonrect.x && event.button.y>=helpbuttonrect.y && event.button.x<helpbuttonrect.x+helpbuttonrect.w && event.button.y<helpbuttonrect.y+helpbuttonrect.h)
				{
					helpbuttonglow=true;
					
					SDL_FillRect(screen,&helpbuttonrect,SDL_MapRGB(screen->format, 0xF0, 0xF0, 0xF0));
					puttext(helpbuttonrect.x+3,helpbuttonrect.y+3,2,SDL_MapRGB(screen->format, 0x00, 0x40, 0x80),"HELP");
					soil(helpbuttonrect);

					dohelpflag=true;
				}
				else if (helpbuttonglow && helpbuttonpressed)
				{
					helpbuttonglow=false;
					SDL_FillRect(screen,&helpbuttonrect,SDL_MapRGB(screen->format, 0x00, 0x40, 0x80));
					puttext(helpbuttonrect.x+3,helpbuttonrect.y+3,2,SDL_MapRGB(screen->format, 0xFF, 0xFF, 0xFF),"HELP");
					soil(helpbuttonrect);	
				}
				helpbuttonpressed=false;
				if (newgamebuttonpressed && event.button.x>=newgamebuttonrect.x && event.button.y>=newgamebuttonrect.y && event.button.x<newgamebuttonrect.x+newgamebuttonrect.w && event.button.y<newgamebuttonrect.y+newgamebuttonrect.h)
				{
					newgamebuttonglow=true;
					
					SDL_FillRect(screen,&newgamebuttonrect,SDL_MapRGB(screen->format, 0xF0, 0xF0, 0xF0));
					puttext(newgamebuttonrect.x+3,newgamebuttonrect.y+3,2,SDL_MapRGB(screen->format, 0x00, 0x40, 0x80),"NEW GAME");
					soil(newgamebuttonrect);

					donewgameflag=true;
				}
				else if (newgamebuttonglow && newgamebuttonpressed)
				{
					newgamebuttonglow=false;
					SDL_FillRect(screen,&newgamebuttonrect,SDL_MapRGB(screen->format, 0x00, 0x40, 0x80));
					puttext(newgamebuttonrect.x+3,newgamebuttonrect.y+3,2,SDL_MapRGB(screen->format, 0xFF, 0xFF, 0xFF),"NEW GAME");
					soil(newgamebuttonrect);	
				}
				newgamebuttonpressed=false;
				if (difficultybuttonpressed && event.button.x>=difficultybuttonrect.x && event.button.y>=difficultybuttonrect.y && event.button.x<difficultybuttonrect.x+difficultybuttonrect.w && event.button.y<difficultybuttonrect.y+difficultybuttonrect.h)
				{
					difficultybuttonglow=true;
					
					SDL_FillRect(screen,&difficultybuttonrect,SDL_MapRGB(screen->format, 0xF0, 0xF0, 0xF0));
					switch(options.difficulty)
					{
						case NORMAL:
							puttext(difficultybuttonrect.x+3,difficultybuttonrect.y+3,2,SDL_MapRGB(screen->format, 0x00, 0x40, 0x80),"DIFFICULTY  NORMAL");
						break;
						case EASY:
							puttext(difficultybuttonrect.x+3,difficultybuttonrect.y+3,2,SDL_MapRGB(screen->format, 0x00, 0x40, 0x80),"DIFFICULTY  EASY");
						break;
						case HARD:
							puttext(difficultybuttonrect.x+3,difficultybuttonrect.y+3,2,SDL_MapRGB(screen->format, 0x00, 0x40, 0x80),"DIFFICULTY  HARD");
						break;
						default:
							fprintf(stderr,"Unknown difficulty -- that can't happen!\n");
						break;
					}
					soil(difficultybuttonrect);

					dodifficultyflag=true;
				}
				else if (difficultybuttonglow && difficultybuttonpressed)
				{
					difficultybuttonglow=false;
					SDL_FillRect(screen,&difficultybuttonrect,SDL_MapRGB(screen->format, 0x00, 0x40, 0x80));
					switch(options.difficulty)
					{
						case NORMAL:
							puttext(difficultybuttonrect.x+3,difficultybuttonrect.y+3,2,SDL_MapRGB(screen->format, 0x00, 0x40, 0x80),"DIFFICULTY  NORMAL");
						break;
						case EASY:
							puttext(difficultybuttonrect.x+3,difficultybuttonrect.y+3,2,SDL_MapRGB(screen->format, 0x00, 0x40, 0x80),"DIFFICULTY  EASY");
						break;
						case HARD:
							puttext(difficultybuttonrect.x+3,difficultybuttonrect.y+3,2,SDL_MapRGB(screen->format, 0x00, 0x40, 0x80),"DIFFICULTY  HARD");
						break;
						default:
							fprintf(stderr,"Unknown difficulty -- that can't happen!\n");
						break;
					}
					soil(difficultybuttonrect);	
				}
				difficultybuttonpressed=false;
			}
#else
				if (menubuttonpressed && event.button.x>=menubuttonrect.x && event.button.y>=menubuttonrect.y && event.button.x<menubuttonrect.x+menubuttonrect.w && event.button.y<menubuttonrect.y+menubuttonrect.h)
				{
					menubuttonglow=true;
					
					SDL_FillRect(screen,&menubuttonrect,SDL_MapRGB(screen->format, 0xF0, 0xF0, 0xF0));
					puttext(menubuttonrect.x+3,menubuttonrect.y+3,2,SDL_MapRGB(screen->format, 0x00, 0x40, 0x80),"MENU");
					soil(menubuttonrect);

					domenuflag=true;
				}
				else if (menubuttonglow && menubuttonpressed)
				{
					menubuttonglow=false;
					SDL_FillRect(screen,&menubuttonrect,SDL_MapRGB(screen->format, 0x00, 0x40, 0x80));
					puttext(menubuttonrect.x+3,menubuttonrect.y+3,2,SDL_MapRGB(screen->format, 0xFF, 0xFF, 0xFF),"MENU");
					soil(menubuttonrect);	
				}
				menubuttonpressed=false;
#endif			
			else if (event.type == SDL_ACTIVEEVENT && ((options.autopause == AUTOPAUSEON) || (event.active.state & SDL_APPACTIVE)))
			{   
				if (event.active.gain==0)
				{ // iconified / lost focus
					paused=true;
				}
				else // event.active.gain==1
				{ // restored /got focus
					paused=false;
				}
			}
			// FIX -- add keyboard support, handle other events.
#ifdef MAEMO  			
			hgw_msg_compat_receive(hgw_context, 0);
#endif
		}
		if (paused) 
		{
			SDL_WaitEvent(NULL);
			continue;
		}
		
		
		
		// move split-lines
		if (line1.on)
		{
			// kludgy crap to implement speed = 1 1/2
			linedoneflag=moveline(&line1);
			if (!linedoneflag && line1.speedslower)
			{
				line1.speedslower=false;
				linedoneflag=moveline(&line1);
			}
			else
			{
				line1.speedslower=true;
			}
				
			if (linedoneflag)
			{
				clear=(100-(countcleared()*100/(PLAYWIDTH*PLAYHEIGHT)));
				levelscore->basescore=(int)(clear*scoremod)-timepenalty;
				tick=0; // reset this to keep score from seeming to flicker around a lot. and to be nice. :)
				
				updatestatuscleared(clear);
				updatestatusscore(oldscore+levelscore->basescore);
				//printf("Cleared: %d%%\n",clear);				
			}

			if (line1.dead) 
			{
				playsound(SNDBREAK);
				killline(&line1);
				lives--;
				if (lives<0) lives=0;
				updatestatuslives(lives);
				//printf("Lives: %d\n",lives); 
			}
		}
		if (line2.on)
		{
			linedoneflag=moveline(&line2);
			if (!linedoneflag && line2.speedslower)
			{
				line2.speedslower=false;
				linedoneflag=moveline(&line2);
			}
			else
			{
				line2.speedslower=true;
			}

			if (linedoneflag)
			{
				clear=(100-(countcleared()*100/(PLAYWIDTH*PLAYHEIGHT)));
				levelscore->basescore=(int)(clear*scoremod)-timepenalty;
				tick=0; // reset this to keep score from seeming to flicker around a lot. and to be nice. :)

				updatestatuscleared(clear);
				updatestatusscore(oldscore+levelscore->basescore);
				//printf("Cleared: %d%%\n",clear);
			}

			if (line2.dead)
			{ 
				playsound(SNDBREAK);
				killline(&line2);
				lives--;
				if (lives<0) lives=0;
				updatestatuslives(lives);
				//printf("Lives: %d\n",lives);
				
			}
		}
		
	
		// move (and get old background)
		for (i=0;i<penguincount;i++)
		{
			
			soil(flock[i].geom); // mark the penguin's old position as dirty
			movepenguin(&flock[i]);
		
			soil(flock[i].geom); // mark the penguin's new position as dirty too (it will be soon...)
			savebehindpenguin(&flock[i]);
		}
		

		// actually draw
		for (i=0;i<penguincount;i++)
		{
			drawpenguin(&flock[i]);
		}
#ifdef MAEMO
		if (doquitflag)
		{
			lives=0; // is this the right way?
			doquitflag=false;
			return QUIT;
		}
		
		if (donewgameflag)
		{
			lives=0; // is this the right way?
			done = true;
			returncode=DEAD;
			donewgameflag=false;
		}
		
		if (dohelpflag)
		{
			popuphelp();
			dohelpflag=false;
		}
		
		if (dodifficultyflag)
		{
			int actualdifficulty = options.difficulty;
			popupdifficultymenu();
			if (actualdifficulty != options.difficulty)
			{
				lives=0;
				done = true;
				returncode=DEAD;
			}
			dodifficultyflag=false;
		}
#else
		if (domenuflag)
		{
			switch (popupmenu())
			{
				case POPUPMENUQUITGAME:
					lives=0; // is this the right way?
					done = true;
					return QUIT;
				break;
				case POPUPMENUNEWGAME:
					// hmmm... maybe this could be done better
					done = true;
					returncode=DEAD;
				break;
			}
			
			domenuflag=false;
		}
#endif		
		// update clock
		tick++;
		if (tick>timepenaltyinterval)
		{
			tick=0;
			if (levelscore->basescore>0)
			{
				timepenalty++;
				levelscore->basescore--;
				updatestatusscore(oldscore+levelscore->basescore);
			}
		}
		
		// update screen
		clean();

		// clear for next update
		for (i=0;i<penguincount;i++)
		{
			erasepenguin(&flock[i]);
		}
		
		if (lives<=0) // game over
		{
			done = true;
			returncode=DEAD;
		} 
		else if (!line1.on && !line2.on && clear>=PERCENTREQUIRED) // success!
		{ 
			done = true;
			levelscore->basescore=(int)(clear*scoremod)-timepenalty;
			returncode=PASS;


			levelscore->clearbonus=0;
			// bonuses for clearing lots
			if (clear>PERCENTBONUS)
				levelscore->clearbonus+=(int)((clear-PERCENTBONUS)*bonusmod);
			if (clear>PERCENTEXTRABONUS)
				levelscore->clearbonus+=(int)((clear-PERCENTEXTRABONUS)*(clear-PERCENTEXTRABONUS)*bonusmod);
				
			// bonuses for leftover lives
			levelscore->lifebonus=(int)((lives-1)*3*bonusmod);
		} 

		//printboard();
		
		// oh, if only we could sleep for less than 10ms on 
		// intel. too bad alpha systems suck so much in other
		// ways -- they can sleep with 1ms resolution.
		// (we could on intel with nanosleep, if we were suid root...)
		SDL_Delay(10);
		
	} while (!done);


	// make sure visible penguins are actually in the screen memory.
	for (i=0;i<penguincount;i++)
	{
		drawpenguin(&flock[i]);
	}

	clean();
	return returncode;
}
#ifdef MAEMO
void statesave(int *level, ScoreSheet *levelscore) 
{
		FILE *pFile;
		int i;
		int j,k;
		pFile = fopen("/tmp/.icebreaker-save", "wb");
		if(pFile) {
			fwrite(&options.difficulty, sizeof(int), 1, pFile);
			
			fwrite(&oldscore, sizeof(int), 1, pFile);
			fwrite(&clear, sizeof(int), 1, pFile);
			fwrite(&lives, sizeof(int), 1, pFile);
			fwrite(level, sizeof(int), 1, pFile);
			
			fwrite(levelscore, sizeof(levelscore), 1, pFile);
			fwrite(&penguincount , sizeof(int), 1, pFile);
			
			for (i=0; i<penguincount; i++)
			{
				fwrite(&(flock[i].geom), sizeof(SDL_Rect)+3*sizeof(int), 1, pFile);
			}

			for (i = 0; i < WIDTH; i++) for (j = 0; j < HEIGHT; j++) {
				if (grid[i][j] == '1' || grid[i][j] == '2' || grid[i][j] == '*') grid[i][j] = ' ';
				if (maskgrid[i][j] == '1' || maskgrid[i][j] == '2' || maskgrid[i][j] == '*') maskgrid[i][j] = ' ';
			}				
			for (i=0;i<COLS;i++)
			{
				for (j=0; j<ROWS; j++)
				{
					fputc(grid[i*BLOCKWIDTH+BORDERLEFT][j*BLOCKHEIGHT+BORDERTOP],pFile);
					fputc(maskgrid[i*BLOCKWIDTH+BORDERLEFT][j*BLOCKHEIGHT+BORDERTOP],pFile);
				}
			}
//			fwrite(grid, sizeof(char), WIDTH*HEIGHT, pFile);
//			fwrite(maskgrid, sizeof(char), WIDTH*HEIGHT, pFile);
			

			fclose(pFile);
		}    
}

int loadstatesaved(int *actuallevel, ScoreSheet *levelscore) {
		FILE *pFile;
		int i, level, j, k;
		int x, y, speedslower;
		SDL_Rect geom;
		char a,b;
		Penguin p;
		pFile = fopen("/tmp/.icebreaker-save", "rb");
		if(pFile) {
			fread(&options.difficulty, sizeof(int), 1, pFile);
			
			fread(&oldscore, sizeof(int), 1, pFile);
			fread(&clear, sizeof(int), 1, pFile);
			fread(&lives, sizeof(int), 1, pFile);
			fread(actuallevel, sizeof(int), 1, pFile);
			
			fread(levelscore, sizeof(levelscore), 1, pFile);
			fread(&penguincount , sizeof(int), 1, pFile);
			
			for (i=0; i<penguincount; i++)
			{
				fread(&p.geom, sizeof(SDL_Rect)+3*sizeof(int), 1, pFile);
				flock[i]=createpenguinxyspeed(p.geom.x,p.geom.y,p.speedslower);
			}
			memset(&grid, 'X', WIDTH*HEIGHT);
			memset(&maskgrid, 'X', WIDTH*HEIGHT);
			for (i=0;i<COLS;i++)
			{
				for (j=0; j<ROWS; j++)
				{
					a=fgetc(pFile);
					b=fgetc(pFile);
					for(x=0; x< BLOCKWIDTH; x++)
					{
						for(y=0; y<BLOCKHEIGHT; y++)
						{
							grid[(i*BLOCKWIDTH+BORDERLEFT)+x][(j*BLOCKHEIGHT+BORDERTOP)+y] = a;
							maskgrid[(i*BLOCKWIDTH+BORDERLEFT)+x][(j*BLOCKHEIGHT+BORDERTOP)+y] = b;
						}
					}
				}
			}
			fclose(pFile);
			remove("/tmp/.icebreaker-save");
			return true;
		}
		else {
			return false;
		}    
}
#endif
