/*
* IceBreaker
* Copyright (c) 2000-2001 Matthew Miller <mattdm@mattdm.org>
*   http://www.mattdm.org/
*
* This program is free software; you can redistribute it and/or modify it
* under the terms of the GNU General Public License as published by the Free
* Software Foundation; either version 2 of the License, or (at your option)
* any later version.
*
* This program is distributed in the hope that it will be useful, but
* WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
* or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
* for more details.
*
* You should have received a copy of the GNU General Public License along
* with this program; if not, write to the Free Software Foundation, Inc., 59
* Temple Place, Suite 330, Boston, MA 02111-1307 USA
*
*/

#include <SDL/SDL.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <unistd.h>
#ifndef WIN32
    #include <pwd.h>
#endif
#include <string.h>
#include <sys/types.h>


#include "icebreaker.h"
#include "penguin.h"
#include "line.h"
#include "grid.h"
#include "sound.h"
#include "globals.h"
#include "level.h"
#include "intro.h"
#include "text.h"
#include "transition.h"
#include "hiscore.h"
#include "dialog.h"
#include "options.h"
#include "fullscreen.h"
#include "cursor.h"

#ifdef MAEMO
#if HGW_FUNC
    #include <hgw/hgw.h>
    /* Ugly global. */
    HgwContext *hgw_context = NULL;
#endif
#endif

// global
SDL_Surface * screen;
SDL_Surface * screensave;
SDL_Surface * penguinimage;

char grid[WIDTH][HEIGHT];

char username[50]; // FIX -- move this into the options struct?
char homedir[255];

SDL_Surface * penguinicon;

// functions
int setup(void);
void cleanup(void);
static int exit_callback(int errcode);
static int quit_callback(int errcode);
static int flush_callback(int errcode);


/************************************************************************/

int setup(void)
{
    struct passwd * userinfo;
    int newuser=false;

    srandom(time(NULL));

    //stupid buffers
    setvbuf(stdout,(char *)NULL, _IOLBF, 0);

//    userinfo = getpwuid(getuid()); // FIX -- make this part of the options struct; and maybe save in options file
//    strncpy(username,userinfo->pw_name,50); // not like it's gonna be fifty characters. but y'know.
//    strncpy(homedir,userinfo->pw_dir,255);
#ifndef MAEMO
    readhiscores();
    newuser=readoptions();
#else
    setdefaultoptions();
#endif
    if (SDL_Init(SDL_INIT_VIDEO))
    {
        fprintf(stderr, "Hey. We're gonna need some graphics.\n"
                        "SDL error: "
                        "%s\n\n", SDL_GetError());
        exit(1);
    }


    //atexit(SDL_Quit);
    atexit(cleanup);
#ifndef MAEMO
    penguinicon = SDL_LoadBMP(DATAPREFIX "/" PENGUINICONFILE);
#else
    penguinicon = SDL_LoadBMP(IMAGEPREFIX "/" PENGUINICONFILE);
#endif
    if (penguinicon==NULL) fprintf(stderr, "Icon not loaded!\n");
    SDL_WM_SetIcon(penguinicon,NULL);

    SDL_WM_SetCaption("IceBreaker","IceBreaker");

    if (options.fullscreen!=FULLSCREENOFF)
    {
        screen = SDL_SetVideoMode(FULLWIDTH, FULLHEIGHT, 16, SDL_HWSURFACE | SDL_FULLSCREEN);
    }
    else
    {
        screen = SDL_SetVideoMode(FULLWIDTH, FULLHEIGHT, 16, SDL_HWSURFACE | SDL_DOUBLEBUF);
    }
    if (screen == NULL)
    {
        fprintf(stderr, "Help! Couldn't get a window.\n"
                        "SDL error: " 
                        "%s\n\n", SDL_GetError());
        exit(1);
    }


    screensave = SDL_CreateRGBSurface(SDL_SWSURFACE,screen->w,screen->h,16,0,0,0,0);

#ifndef MAEMO
    // FIX -- need "initpenguin" routine. and some error checking!
    penguinimage = SDL_LoadBMP(DATAPREFIX "/" PENGUINBMPFILE);
#else
    penguinimage = SDL_LoadBMP(IMAGEPREFIX "/" PENGUINBMPFILE);
#endif
    SDL_SetColorKey(penguinimage, SDL_SRCCOLORKEY, SDL_MapRGB(penguinimage->format, 0xFF, 0x00, 0x00));


    // FIX -- need preference.
    initsound();

    inittext();


    return newuser;
}

void cleanup()
{
    //writehiscores(); // now written only when hi score is actually achieved
    quitsound();
    SDL_Quit();
    writeoptions();
}



int main(int argc,char *argv[])
{
#ifdef MAEMO
    #ifdef ENABLE_NLS
    /* Initialize localization */
    /* Getttext does not seem to work properly without
    the following function call */
    setlocale(LC_ALL, "");

    bindtextdomain(GETTEXT_PACKAGE, LMARBLESLOCALEDIR);
    bind_textdomain_codeset(GETTEXT_PACKAGE, "UTF-8");
    textdomain(GETTEXT_PACKAGE);
    #endif /* ENABLE_NLS */


    #if HGW_FUNC
    hgw_context = hgw_context_compat_init(argc, argv);

    if(hgw_context == NULL)
    {
        return 0;
    }
    hgw_compat_set_cb_exit(hgw_context, exit_callback);
    hgw_compat_set_cb_quit(hgw_context, quit_callback);
    hgw_compat_set_cb_flush(hgw_context, flush_callback);

    if(!hgw_context_compat_check(hgw_context))
    {
        return 0;
    }

    /* Shadow app part */
    hgw_msg_compat_receive(hgw_context, 0);
    usleep(100);
    #endif
#endif
    int done = false;
    int level=0;
    ScoreSheet levelscore;
    long totalscore=0;
    char windowtitle[35];
    LevelExitType levelresult;
    int newuser=false;
#ifdef MAEMO
    FILE *pFile;
#endif
    newuser=setup();
#ifdef MAEMO
    pFile = fopen("/tmp/.icebreaker-save", "rb");
    if (!pFile)
        done=intro();
#else
    done=intro();
#endif
    if (!done && newuser)
    { // no options file; using the default
        setcursor(CURSORCLICK);
        popuphelp();
        setcursor(CURSORARROW);
    }

    while(!done)
    {
        level++;
        if (level>=MAXPENGUINS) level=MAXPENGUINS-1;

#ifndef MAEMO
        switch (options.difficulty)
        {
            case NORMAL:
                snprintf(windowtitle,35,"IceBreaker -- Level %d",level);
            break;
            case HARD:
                snprintf(windowtitle,35,"IceBreaker -- Level %d (Hard)",level);
            break;
            case EASY:
                snprintf(windowtitle,35,"IceBreaker -- Level %d (Easy)",level);
            break;
        }
#else
        snprintf(windowtitle,35,"IceBreaker -- Level %d",level);
#endif
        SDL_WM_SetCaption(windowtitle,"IceBreaker");

        levelresult=playlevel(&level,totalscore,&levelscore);
          SDL_WM_SetCaption("IceBreaker","IceBreaker");

        totalscore+= levelscore.basescore + levelscore.clearbonus + levelscore.lifebonus;

        if (levelresult == QUIT)
        {
#if HGW_FUNC
                        quit_callback(0);
#endif
            done=true;
        }
        else if (levelresult == PAUSE)
        {
            done=true;
#if HGW_FUNC
            exit_callback(0);
#endif
        }
        else if (levelresult == DEAD)
        {
            done=gameover(totalscore);

            // hooray! modifying the index variable in the loop!
            // good coding practice at its finest!
            level=0;
            totalscore=0;
        }
        else if (levelresult == ERROR)
        {
            fprintf(stderr,"Level error -- this should never happen.\n");
        }
        else
        {
            // level completed successfully
            done=intermission(&levelscore,level+1);
        }
    }
    //printf("===========================================================\n");
    //printf("\nFinal Score: %ld\n",totalscore);

/* Free memory */
#ifdef MAEMO
    #if HGW_FUNC
    hgw_context_compat_destroy_deinit(hgw_context);
    #endif
#endif
    return(0);
}

#ifdef MAEMO
    #if HGW_FUNC
static int exit_callback(int errcode)
{
//  hgw_notify_startup(hgw_context, HGW_SUN_PAUSE);

  return 0;
}

static int quit_callback(int errcode)
{
  remove("/tmp/.icebreaker-save");

  //hgw_context_compat_destroy_quit(hgw_context);

  return 0;
}

static int flush_callback(int errcode)
{
  remove("/tmp/.icebreaker-save");

  return 0;
}
    #endif
#endif
